//
//  NetworkRequestClassManager.h
//  Lighting
//
//  Created by 曹云霄 on 16/4/28.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "opple_objc_json_client.h"

//定义返回数据的block类型
typedef void (^ReturnValueBlock) (id returnValue);
typedef void (^ErrorCodeBlock) (id errorCodeValue);
typedef void (^FailureBlock)(NSError *error);


//定义请求类型
typedef enum {
    
    NetworkRequestWithPOST = 0, //POST
    NetworkRequestWithGET       //GET
    
}NetworkRequestType;


@interface NetworkRequestClassManager : NSObject

/**
 *  网络请求单例
 *
 *  @return NetworkRequestClassManager
 */
+ (NetworkRequestClassManager *)Manager;


/**
 *  网络请求
 *
 *  @param requestURLString     网址
 *  @param requestType          请求类型
 *  @param parameter            JAstor对象
 *  @param sueecssBlock         成功回调
 *  @param errorCodeBlock       错误编码回调
 *  @param failureBlock         失败回调
 */
- (void)NetworkRequestWithURL:(NSString *) requestURLString
                  WithRequestType:(NetworkRequestType) requestType
                    WithParameter:(JSONModel *) jastorobject
             WithReturnValueBlock:(ReturnValueBlock) successBlock
              WithErrorCodeBlock:(ErrorCodeBlock) errorCodeBlock
                 WithFailureBlock:(FailureBlock) failureBlock;






/**
 *  网络请求
 *
 *  @param requestURLString     网址
 *  @param requestType          请求类型
 *  @param parameter            字典对象
 *  @param sueecssBlock         成功回调
 *  @param errorCodeBlock       错误编码回调
 *  @param failureBlock         失败回调
 */
- (void)NetworkWithDictionaryRequestWithURL:(NSString *) requestURLString
              WithRequestType:(NetworkRequestType) requestType
                WithParameter:(NSDictionary *) parameter
         WithReturnValueBlock:(ReturnValueBlock) successBlock
           WithErrorCodeBlock:(ErrorCodeBlock) errorCodeBlock
             WithFailureBlock:(FailureBlock) failureBlock;



/**
 *  下载PDF
 *
 *  @param requestURLString 网址
 *  @param successBlock     成功回调
 *  @param errorCodeBlock   错误编码回到
 *  @param failureBlock     失败回调
 */
- (void)DownloadPDFdatasWithURL:(NSString *) requestURLString
           WithReturnValueBlock:(ReturnValueBlock) successBlock
             WithErrorCodeBlock:(ErrorCodeBlock) errorCodeBlock
               WithFailureBlock:(FailureBlock) failureBlock;





@end
