//
//  ShoppingView.m
//  Lighting
//
//  Created by mac on 16/5/23.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ShoppingView.h"

@interface ShoppingView ()
{
    NSMutableArray * textArray;
}

@end

@implementation ShoppingView

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initdata];
    [self initView];
    // Do any additional setup after loading the view.
}
-(void)initdata
{
    self.isAllSelected=NO;
    self.nameDataArray=[[NSMutableArray alloc]initWithObjects:@"",@"图片",@"产品信息",@"吊牌价",@"成交价",@"",@"数量",@"",@"产品金额", nil];
    self.productModelArray=[[NSMutableArray alloc]init];
    textArray=[[NSMutableArray alloc]initWithObjects:@"1",@"1",@"1",@"1",@"1", nil];
    self.selectTagArray=[[NSMutableArray alloc]init];
}
-(void)initView
{
    self.subView=[[UIView alloc]initWithFrame:CGRectMake(100, 50, ScreenWidth-250, ScreenHeight-200)];
    self.subView.backgroundColor=[UIColor whiteColor];
    [self.view  addSubview:self.subView];
    
    //点击手势
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(DismissScreenView:)];
    tap.delegate = self;
    tap.cancelsTouchesInView = NO;
    [[UIApplication sharedApplication].keyWindow addGestureRecognizer:tap];
    [self initSubViews];
}
-(void)initSubViews
{
    self.headerView=[[UIView alloc]initWithFrame:CGRectMake(0, 0, self.subView.frame.size.width, 50)];
    [self.subView addSubview:self.headerView];
    UIButton *btn=[UIButton buttonWithType:UIButtonTypeCustom];
    btn.frame=CGRectMake(10, 10, 30, 30);
    [btn setBackgroundImage:[UIImage imageNamed:@"addshopping"] forState:UIControlStateNormal];
    [self.headerView addSubview:btn];
    UILabel *lable=[[UILabel alloc]initWithFrame:CGRectMake(45, 10, 100, 30)];
    lable.text=@"待添加购物车";
    [self.headerView addSubview:lable];
    
    self.toolView=[[UIView alloc]initWithFrame:CGRectMake(0,50, self.subView.frame.size.width, 50)];
     self.toolView.backgroundColor=[UIColor grayColor];
    [self.subView addSubview:self.toolView];
    for (int i=0; i<self.nameDataArray.count; i++) {
        UIButton *btn=[UIButton buttonWithType:UIButtonTypeCustom];
        btn.frame=CGRectMake(self.subView.frame.size.width/9*i, 10, self.subView.frame.size.width/9, 30);
        [btn setTitle:[self.nameDataArray objectAtIndex:i] forState:UIControlStateNormal];
        [self.toolView addSubview:btn];
    }
    self.shoppingTableView=[[UITableView alloc]initWithFrame:CGRectMake( 0,100, self.subView.frame.size.width, self.subView.frame.size.height-200)];
    self.shoppingTableView.delegate=self;
    self.shoppingTableView.dataSource=self;
    [self.subView addSubview:self.shoppingTableView];
    
    self.footView=[[UIView alloc]initWithFrame:CGRectMake(0, self.subView.frame.size.height-100, self.subView.frame.size.width, 100)];
    [self.subView addSubview:self.footView];
    UIButton *allSelectedBtn=[[UIButton alloc]initWithFrame:CGRectMake(20, 35, 30, 30)];
    [allSelectedBtn addTarget:self action:@selector(allSelected:) forControlEvents:UIControlEventTouchUpInside];
    [allSelectedBtn setBackgroundImage:[UIImage imageNamed:@"box-副本"] forState:UIControlStateNormal];
    [self.footView addSubview:allSelectedBtn];
    UILabel *allLable=[[UILabel alloc]initWithFrame:CGRectMake(70, 35, 50, 50)];
    allLable.text=@"全选";
    [self.footView addSubview:allLable];
    UIButton * delegateBtn=[[UIButton alloc]initWithFrame:CGRectMake(150, 35, 30, 30)];
    [delegateBtn setBackgroundImage:[UIImage imageNamed:@"Trash"] forState:UIControlStateNormal];
    [delegateBtn addTarget:self action:@selector(delegateProduct:) forControlEvents:UIControlEventTouchUpInside];
    [self.footView addSubview:delegateBtn];
    UILabel *delegatelable=[[UILabel alloc]initWithFrame:CGRectMake(210, 35, 50, 50)];
    delegatelable.text=@"删除";
     [self.footView addSubview:delegatelable];
    UILabel *totalAmountName=[[UILabel alloc]initWithFrame:CGRectMake(self.footView.frame.size.width-320, 25, 75, 50)];
    totalAmountName.text=@"合计金额";
    [self.footView addSubview:totalAmountName];
      UILabel *totalAmountNum=[[UILabel alloc]initWithFrame:CGRectMake(self.footView.frame.size.width-240, 25, 75, 50)];
   totalAmountNum.text=@"$5500";
    totalAmountNum.textColor=[UIColor redColor];
    [self.footView addSubview:totalAmountNum];
    UIButton *confirmAddBtn=[[UIButton alloc]initWithFrame:CGRectMake(self.footView.frame.size.width-150, 15, 130, 60)];
    [confirmAddBtn setTitle:@"确认添加（0）" forState:UIControlStateNormal];
    [confirmAddBtn addTarget:self action:@selector(addProducts:) forControlEvents:UIControlEventTouchUpInside];
    [confirmAddBtn setBackgroundColor:[UIColor blueColor]];
    [self.footView addSubview:confirmAddBtn];
    
}
//全选
-(void)allSelected:(UIButton*)sender
{
    if (!self.isAllSelected) {
        [sender setBackgroundImage:[UIImage imageNamed:@"bg"] forState:UIControlStateNormal];
        [self.shoppingTableView reloadData];
        self.isAllSelected=YES;
    }else
    {
       [sender setBackgroundImage:[UIImage imageNamed:@"box-副本"] forState:UIControlStateNormal];
        [self.shoppingTableView reloadData];
        self.isAllSelected=NO;
    }
    
}
//删除
-(void)delegateProduct:(UIButton *)sender
{
    self.selectTagArray=[self sequenceProductList:self.selectTagArray];
    if (self.isAllSelected) {
        [textArray  removeAllObjects];
        
    }else
    {
        for (NSString *str in self.selectTagArray) {
            [textArray removeObjectAtIndex:[str integerValue]];
        }
    }
    [self.shoppingTableView reloadData];
}
//选择
-(void)selfctAtIndexpath:(UIButton *)sender
{
    if ([self.selectTagArray containsObject:[NSString stringWithFormat:@"%d",sender.tag]]) {
        [sender setBackgroundImage:[UIImage imageNamed:@"box-副本"] forState:UIControlStateNormal];
        [self.selectTagArray removeObject:[NSString stringWithFormat:@"%d",sender.tag]];
    }else
    {
        [sender setBackgroundImage:[UIImage imageNamed:@"bg"] forState:UIControlStateNormal];
         [self.selectTagArray addObject:[NSString stringWithFormat:@"%d",sender.tag]];
        
    }
   
   
}
//第一种排序  倒序排列

-(NSMutableArray *)sequenceProductList:(NSMutableArray*)productList
{
    
    //    数组排序
    NSComparator cmptr = ^(id obj1, id obj2){
        if ([obj1   integerValue] < [obj2 integerValue]) {
            return (NSComparisonResult)NSOrderedDescending;
        }
        
        if ([obj1 integerValue] > [obj2  integerValue]) {
            return (NSComparisonResult)NSOrderedAscending;
        }
        return (NSComparisonResult)NSOrderedSame;
    };
    
    if ( productList.count>0) {
        productList=[NSMutableArray arrayWithArray:[productList sortedArrayUsingComparator:cmptr] ];
    }
    
    return productList;
}

-(void)addProducts:(UIButton *)sender
{
    //加入购物车
        //判断是否有当前客户
        if (![Shoppersmanager manager].currentCustomer) {
            
            [self ErrorMBProgressView:@"必须设置当前客户"];
            return;
        }
        TOGoodsEntity *model = [self.productModelArray objectAtIndex_opple:0];
        [self addGoodsShoppingbags:model complate:^{
            NSLog(@"加入购物车完成");
        }];
       
    

}
#pragma mark -添加至购物车
- (void)addGoodsShoppingbags:(TOGoodsEntity *)model complate:(void(^)())response
{
    
    SaveShoppingCartRequest *shopCar = [[SaveShoppingCartRequest alloc]init];
    shopCar.consumerId = [[Customermanager manager] customerID];
    shopCar.goodsId = model.fid;
    shopCar.count = @"1";
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:[NSString stringWithFormat:@"%@%@",ServerAddress,@"/shopcart/save"] WithRequestType:0 WithParameter:shopCar WithReturnValueBlock:^(id returnValue) {
        
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            
            response();
            
        }else
        {
            [self ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        
        
    } WithFailureBlock:^(id error) {
        [self ErrorMBProgressView:@"加入购物车失败"];
    }];
}


#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return textArray.count;

    
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    
        return 50;
    
    
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *cellID = @"ChooseTansferCell";
    ShoppingCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[ShoppingCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        
    }
    cell.selectedButton.tag=indexPath.row;
    [cell.selectedButton addTarget:self action:@selector(selfctAtIndexpath:) forControlEvents:UIControlEventTouchUpInside];
    if (self.isAllSelected) {
        [cell.selectedButton setBackgroundImage:[UIImage imageNamed:@"bg"] forState:UIControlStateNormal];
    }else
    {
        [cell.selectedButton setBackgroundImage:[UIImage imageNamed:@"box-副本"] forState:UIControlStateNormal];
    }
    
    return cell;
    
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    
}

-(void)DismissScreenView:(UITapGestureRecognizer*)sender{
    CGPoint point = [sender locationInView:self.view];
    if (point.x<100 || point.x >ScreenWidth-150||point.y<50||point.y>ScreenHeight-150) {
        
        if (self) {
            [self.view removeFromSuperview];
        }
    }
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
