//
//  SettlementViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/11.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "SettlementViewController.h"


@interface SettlementViewController ()<ReturnTableviewcellIndexpathdelegate,UITextFieldDelegate>

/**
 *  支付宝二维码
 */
@property (nonatomic,copy) NSString *zhiFubaoLabe;

/**
 *  微信二维码
 */
@property (nonatomic,copy) NSString *weiXinLabe;




@end

@implementation SettlementViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
    [self setGoodsArray];
    [self getPayQrCode];
}




#pragma mark -布局
- (void)uiConfigAction
{
    self.goodsAllNumberBackvie.layer.masksToBounds = YES;
    self.goodsAllNumberBackvie.layer.cornerRadius = kCornerRadius;
    self.goodsAllpriceBackView.layer.masksToBounds = YES;
    self.goodsAllpriceBackView.layer.cornerRadius = kCornerRadius;
    self.payTypeButton.layer.masksToBounds = YES;
    self.payTypeButton.layer.cornerRadius = kCornerRadius;
    self.WeixiPayButton.layer.masksToBounds = YES;
    self.WeixiPayButton.layer.cornerRadius = kCornerRadius;
    self.payTreasureButton.layer.masksToBounds = YES;
    self.payTreasureButton.layer.cornerRadius = kCornerRadius;
    self.ISinvoiceButton.layer.masksToBounds = YES;
    self.ISinvoiceButton.layer.cornerRadius = kCornerRadius;
    self.invoiceType.layer.masksToBounds = YES;
    self.invoiceType.layer.cornerRadius = kCornerRadius;
    self.invoiceBackView.layer.masksToBounds = YES;
    self.invoiceBackView.layer.cornerRadius = kCornerRadius;
    self.cancelButton.layer.masksToBounds = YES;
    self.cancelButton.layer.cornerRadius = kCornerRadius;
    self.sureButton.layer.masksToBounds = YES;
    self.sureButton.layer.cornerRadius = kCornerRadius;
    self.myScrollView.contentSize = CGSizeMake(0, self.view.frame.size.height);
    self.invoiceHeader.delegate = self;
}



#pragma mark -支付总金额，商品总数量
- (void)setGoodsArray
{
    NSInteger goodsAllNumber = 0;//总数量
    CGFloat goodAllprice = 0;//总价格
    for (TOOrderdetailEntity *model in _goodsArray) {
        goodsAllNumber += [model.goodsNum integerValue];
        goodAllprice += [model.goodsPrice floatValue]*[model.goodsNum integerValue];
    }
    self.goodsAllNumber.text = [NSString stringWithFormat:@"%ld",goodsAllNumber];
    self.goodsAllPrice.text = [NSString stringWithFormat:@"￥%.2f",goodAllprice];
}


#pragma mark -获取经营者支付二维码
- (void)getPayQrCode
{
    [[NetworkRequestClassManager Manager ] NetworkWithDictionaryRequestWithURL:[NSString stringWithFormat:@"%@%@",ServerAddress,@"/employee/getReseller"] WithRequestType:1 WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            
            NSLog(@"获取二维码成功");
            self.zhiFubaoLabe = returnValue[@"data"][@"zhifubao"];
            self.weiXinLabe = returnValue[@"data"][@"weixin"];
            
        }else
        {
            NSLog(@"获取二维码失败");
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        
    } WithFailureBlock:^(id error) {
        NSLog(@"%@",error);
    }];
}


- (void)viewWillAppear:(BOOL)animated
{
    self.view.superview.layer.cornerRadius = 0;
}



#pragma mark -取消支付
- (IBAction)CancelButtonClick:(UIButton *)sender {
    
    [self dismissViewControllerAnimated:YES completion:nil];
}


#pragma mark -确认支付
- (IBAction)SureButtonClick:(UIButton *)sender {
    
    if ([self.payTypeButton.currentTitle isEqualToString:@"现金、支票、转账、刷卡"] && !self.payTreasureButton.selected && !self.WeixiPayButton.selected) {
        [self ErrorMBProgressView:@"请选择一种支付方式"];
        
    }else if ([self.invoiceType.currentTitle isEqualToString:@"公司发票"] && self.invoiceHeader.text.length == 0)
    {
        [self ErrorMBProgressView:@"请输入发票抬头"];
    }else
    {
      [self SurePayRequest];
    }
}

#pragma amrk -支付方式选择
- (IBAction)payTypeButtonClick:(UIButton *)sender {
    
    NSArray *arr = @[@"现金",@"支票",@"转账",@"刷卡"];
    [self ShowPopoverViewController:CGSizeMake(100, 200) Withdatas:arr ShowButton:sender SelectedIndex:0 GetTitle:YES];
}

#pragma mark -微信支付
- (IBAction)WechatButtonClick:(UIButton *)sender {
    
    self.showPayQrCodeImageView.hidden = NO;
    sender.selected = !sender.selected;
    if (sender.selected) {
        
        [self.showPayQrCodeImageView sd_setImageWithURL:[NSURL URLWithString:self.weiXinLabe] placeholderImage:REPLACEIMAGE];
        self.payTreasureButton.selected = NO;
        [self.payTypeButton setTitle:@"现金、支票、转账、刷卡" forState:UIControlStateNormal];
    }
}


#pragma mark -支付宝支付
- (IBAction)ZhifubaoPayButtonClick:(UIButton *)sender {
    
    self.showPayQrCodeImageView.hidden = NO;
    sender.selected = !sender.selected;
    if (sender.selected) {
        
        [self.showPayQrCodeImageView sd_setImageWithURL:[NSURL URLWithString:self.zhiFubaoLabe] placeholderImage:REPLACEIMAGE];
        self.WeixiPayButton.selected = NO;
        [self.payTypeButton setTitle:@"现金、支票、转账、刷卡" forState:UIControlStateNormal];
    }
}


#pragma mark -是否开票
- (IBAction)isinvoiceButtonClick:(UIButton *)sender {
    
    NSArray *arr = @[@"是",@"否"];
    [self ShowPopoverViewController:CGSizeMake(50, 150) Withdatas:arr ShowButton:sender SelectedIndex:1 GetTitle:YES];
}


#pragma mark -发票类型
- (IBAction)invoiceTypeButtonClick:(UIButton *)sender {
    
    if ([self.ISinvoiceButton.currentTitle isEqualToString:@"否"]) {
        [self ErrorMBProgressView:@"请选择开票"];
        return;
    }
    NSArray *arr = @[@"个人发票",@"公司发票"];
    [self ShowPopoverViewController:CGSizeMake(100, 150) Withdatas:arr ShowButton:sender SelectedIndex:2 GetTitle:YES];
}



#pragma mark -弹出popover视图控制器
- (void)ShowPopoverViewController:(CGSize)size Withdatas:(NSArray *)datasArray ShowButton:(UIButton *)button SelectedIndex:(NSInteger)index GetTitle:(BOOL )istitle
{
    
    PopoverViewController *popover = [[PopoverViewController alloc]init];
    popover.datasArray = datasArray;
    popover.delegate = self;
    popover.Selectedindex = index;
    popover.isString = YES;
    popover.contentSize = size;
    popover.preferredContentSize = size;
    popover.modalPresentationStyle = UIModalPresentationPopover;
    UIPopoverPresentationController *pop = popover.popoverPresentationController;
    pop.permittedArrowDirections = UIPopoverArrowDirectionUp;
    pop.sourceView = popover.view;
    pop.barButtonItem = [[UIBarButtonItem alloc]initWithCustomView:button];
    [self presentViewController:popover animated:YES completion:nil];
}



/**
 *  选中筛选条件对象typecode
 *
 *  @param index NSString
 */
- (void)returnCellindexpathwithrow:(NSString *)Type WithcellTitle:(NSString *)title Withselected:(NSInteger)Selected
{
    [self dismissViewControllerAnimated:YES completion:nil];
    
    switch (Selected) {
        case 0://支付方式
        {
            [self.payTypeButton setTitle:title forState:UIControlStateNormal];
            self.payTreasureButton.selected = NO;
            self.WeixiPayButton.selected = NO;
            self.showPayQrCodeImageView.hidden = YES;
        }
            break;
        case 1://是否开票
        {
            [self.ISinvoiceButton setTitle:title forState:UIControlStateNormal];
        }
            break;
        case 2://发票类型
        {
            [self.invoiceType setTitle:title forState:UIControlStateNormal];
        }
            break;
            
        default:
            break;
    }
}



#pragma mark -确认支付请求
- (void)SurePayRequest
{
    
    OrderPayRequest *order = [[OrderPayRequest alloc]init];
    order.orderNumber =  _orderCode;
    order.fnewstate =  @"002";
    order.oldstate =  @"001";
    //支付类型
    if (self.payTreasureButton.selected) {
        
       order.payType =  @"005";
        
    }else if (self.WeixiPayButton.selected)
    {
        order.payType = @"006";
    }else
    {
        order.payType =  [self PayTypeSelected:self.payTypeButton.currentTitle];
    }
    //是否开票
    if ([self.ISinvoiceButton.currentTitle isEqualToString:@"是"]) {
        order.isbill = @"Y";
    }
    else if ([self.ISinvoiceButton.currentTitle isEqualToString:@"否"]){
       order.isbill =  @"N";
    }
    //发票类型
    if ([self.invoiceType.currentTitle isEqualToString:@"公司发票"]) {
        
        order.billType =  @"001";
        if (self.invoiceHeader.text.length == 0 || !self.invoiceHeader.text) {
            [self ErrorMBProgressView:@"发票抬头不能为空"];
            return;
        }
    }else if ([self.invoiceType.currentTitle isEqualToString:@"个人发票"])
    {
        order.billType =  @"002";
    }
    
    
    [self CreateMBProgressHUDLoding];
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:[NSString stringWithFormat:@"%@%@",ServerAddress,@"/order/payOrder"] WithRequestType:0 WithParameter:order WithReturnValueBlock:^(id returnValue) {
        
        [self CreateMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            NSLog(@"支付成功");
            [self ErrorMBProgressView:@"支付成功"];
            if (self.PaySuccessReturnBlock) {
                self.PaySuccessReturnBlock();
            }
            [self dismissViewControllerAnimated:YES completion:nil];
        }
    } WithErrorCodeBlock:^(id errorCodeValue) {
        
    } WithFailureBlock:^(id error) {
        NSLog(@"支付失败");
        [self CreateMBProgressHUDLoding];
    }];
}


#pragma mark -支付方式选择
- (NSString *)PayTypeSelected:(NSString *)selecte
{
    NSString *payCode = nil;
    if ([selecte isEqualToString:@"现金"]) {
        return payCode = @"001";
    }
    if ([selecte isEqualToString:@"刷卡"]) {
        return payCode = @"002";
    }
    if ([selecte isEqualToString:@"转账"]) {
        return payCode = @"003";
    }
    if ([selecte isEqualToString:@"支票"]) {
        return payCode = @"004";
    }
    return nil;
}



//@synthesize orderNumber;
//@synthesize oldstate;
//@synthesize fnewstate;
//@synthesize payType;
//@synthesize isbill;
//@synthesize billType;
//@synthesize billTitle;

#pragma mark -汉字转码
- (NSString *)ReturnUrlString:(NSString *)ChineseString
{
    NSString* encodedString = [ChineseString stringByAddingPercentEncodingWithAllowedCharacters:[NSCharacterSet URLQueryAllowedCharacterSet]];
    return encodedString;
}


#pragma mark -开始编辑
- (BOOL)textFieldShouldBeginEditing:(UITextField *)textField
{
    if ([self.ISinvoiceButton.currentTitle isEqualToString:@"否"]) {
        [self ErrorMBProgressView:@"请选择开票"];
        return NO;
    }
    return YES;
}


#pragma mark -结束编辑
- (void)textFieldDidEndEditing:(UITextField *)textField
{
    self.myScrollView.contentOffset = CGPointMake(0, 0);
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
