//
//  FollowHeartViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/4.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "FollowHeartViewController.h"
#import <QuartzCore/QuartzCore.h>
#import "ImageCropperView.h"

@interface FollowHeartViewController ()

@end

@implementation FollowHeartViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self configSubView];
    
}
-(void)configSubView
{
    self.productModelArray=[[NSMutableArray alloc]init];
    self.backGroundImageView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"backView.png"]];
    self.backGroundImageView.frame=CGRectMake(0, 0, ScreenWidth, ScreenHeight);
    [self.view addSubview:self.backGroundImageView];
    self.leftSubView=[[LeftSubView alloc]initWithFrame:CGRectMake(0, 0, 200, ScreenHeight-150)];
    self.leftSubView.delegate=self;
    [self.view addSubview:self.leftSubView];
    self.rightSubView=[[RightSubView alloc]initWithFrame:CGRectMake(ScreenWidth-200, 0, 200, ScreenHeight-150)];
    self.rightSubView.delegate=self;
    [self.view addSubview:self.rightSubView];
    
    self.footSubView=[[FootSubView alloc]initWithFrame:CGRectMake(0, ScreenHeight-150, ScreenWidth, 150)];
    self.footSubView.delegate=self;
    [self.view addSubview:self.footSubView];
   
}

#pragma  subView  delegate
- (void)buttonClick:(NSInteger)btnTag withButton:(UIButton *)button
{
    switch (btnTag) {
        case 100:  //返回
        {
            [self.view removeFromSuperview];
        }
            break;
        case 101:  //购物车
        {
             [self addShoppingView];
        }
            break;
        case 102:  //分享
        {
            [self addShareView:button];
        }
            break;
        case 103:  //自定义场景
        {
            [self addCameraView:button];
        }
            break;
        case 104:  //全屏
        {

            [self setViewAnimations:button];
            
        }
            break;
        case 105: //帮助
        {
            
        }
            break;
        case 200: //场景
        {
            [self addSceneLibraryView];
        }
            break;
        case 300: //产品
        {
            [self addProductLibraryView];
        }
            break;
            
        default:
            break;
    }

}
-(void)addShareView:(UIButton *)sender
{
    ShareViewController *shareVC = [[ShareViewController alloc]init];
    shareVC.delegate = self;
    shareVC.preferredContentSize = CGSizeMake(280, 150);
    shareVC.modalPresentationStyle = UIModalPresentationPopover;
    UIPopoverPresentationController *pop = shareVC.popoverPresentationController;
//    箭头方向
    pop.permittedArrowDirections = UIPopoverArrowDirectionAny;
    pop.sourceView = shareVC.view;
    pop.barButtonItem = [[UIBarButtonItem alloc]initWithCustomView:sender];
    [self presentViewController:shareVC animated:YES completion:nil];

}
//添加自定义场景
-(void)addCameraView:(UIButton *)sender
{
    self.cameraView=[[CameraView alloc]init];
    self.cameraView.view.backgroundColor=[UIColor clearColor];
    self.cameraView.delegate=self;
    [self.view addSubview:self.cameraView.view];
}
//自定义场景附图回调
- (void)addCustomPictureImage:(UIImage *)image
{
    [self.footSubView addFootSubViewImage:image];
    self.backGroundImageView.image=image;
}
//添加场景图
- (void)resetSuperBackGroundImage:(UIImage*)image
{
    self.backGroundImageView.image=image;
}
//添加产品图
- (void)resetSubProductImage:(UIImage*)image productModel:(NSMutableArray *)productModel
{
    ImageCropperView *cropper=[[ImageCropperView alloc]initWithFrame:CGRectMake(400, 300, 300, 300)];
    cropper.image = image;
    [self.view addSubview:cropper];
}
//场景库选图回调
- (void)addSeceneImage:(UIImage *)image
{
    [self.footSubView addFootSubViewImage:image];
}
//产品库选图回调
- (void)addProductImage:(UIImage *)image productModel:(TOGoodsEntity *)productModel
{
    [self.rightSubView addRightSubViewImage:image productModel:productModel];
}
//分享回调
- (void)ShareProductImage:(UIImage *)image
{
    //    先截屏 并保存图片
    [self savePhoto];
}
//全屏
-(void)setViewAnimations:(UIButton *)sender
{
    self.zoomButton=sender;
    self.zoomButton.hidden=YES;
    self.temporaryBtn=[UIButton buttonWithType:UIButtonTypeCustom];
    self.temporaryBtn.frame=sender.frame;
    [self.temporaryBtn setBackgroundImage:[UIImage imageNamed:@"xiaoping"] forState:UIControlStateNormal];
    [self.temporaryBtn addTarget:self action:@selector(resetViewDidSelected:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:self.temporaryBtn];

    [UIView beginAnimations:@"quanping" context:nil];
    [UIView setAnimationDelegate:self];
    [UIView setAnimationDuration:1.0f];
    self.leftSubView.frame=CGRectMake(-200, 0, 200, ScreenHeight-150);
    self.rightSubView.frame=CGRectMake(ScreenWidth, 0, 200, ScreenHeight-150);
    self.footSubView.frame=CGRectMake(0, ScreenHeight, ScreenWidth, 150);
    self.temporaryBtn.frame=CGRectMake(sender.frame.origin.x, 20, sender.frame.size.width, sender.frame.size.height);
    [UIView commitAnimations];
}
-(void)resetViewDidSelected:(UIButton *)sender
{
    [sender setBackgroundImage:[UIImage imageNamed:@"quanping"] forState:UIControlStateNormal];
    [UIView beginAnimations:@"xiaoping" context:nil];
    [UIView setAnimationDelegate:self];
    [UIView setAnimationDidStopSelector:@selector(animationFinish)];
    [UIView setAnimationDuration:1.0f];
    self.leftSubView.frame=CGRectMake(0, 0, 200, ScreenHeight-150);
    self.rightSubView.frame=CGRectMake(ScreenWidth-200, 0, 200, ScreenHeight-150);
    self.footSubView.frame=CGRectMake(0, ScreenHeight-150, ScreenWidth, 150);
    sender.frame=self.zoomButton.frame;
    [UIView commitAnimations];
  
}
-(void)animationFinish
{
     self.zoomButton.hidden=NO;
    [self.temporaryBtn removeFromSuperview];
}
//添加场景
-(void)addSceneLibraryView
{

    self.seceneLibraryView=[[SeceneLibraryView alloc]init];
    self.seceneLibraryView.view.backgroundColor=[UIColor clearColor];
    self.seceneLibraryView.delegate=self;
    [self.view addSubview:self.seceneLibraryView.view];
}
//添加产品
-(void)addProductLibraryView
{
    self.productLibraryView=[[ProductLibraryView alloc]init];
    self.productLibraryView.view.backgroundColor=[UIColor clearColor];
    self.productLibraryView.delegate=self;
    [self.view addSubview:self.productLibraryView.view];
}
//添加购物车
-(void)addShoppingView
{
    self.shoppingView=[[ShoppingView alloc]init];
    self.shoppingView.view.backgroundColor=[UIColor clearColor];
    self.shoppingView.productModelArray=self.productModelArray;
//    self.shoppingView.delegate=self;
    [self.view addSubview:self.shoppingView.view];
    
}
// 保存图片到相册功能，ALAssetsLibraryiOS9.0 以后用photoliabary 替代，

-(void)savePhoto

{
    
    UIImage * image = [self captureImageFromView:self.view];
    [self saveImageToPhotos:image];
    //
    //    PhysicalAddress
    ////    * library = [ALAssetsLibrary new];
    //
    ////    NSData * data = UIImageJPEGRepresentation(image, 1.0);
    ////
    ////    [library writeImageDataToSavedPhotosAlbum:data metadata:nil completionBlock:nil];
    
}
- (void)saveImageToPhotos:(UIImage*)savedImage

{
    UIImageWriteToSavedPhotosAlbum(savedImage, self, @selector(image:didFinishSavingWithError:contextInfo:), NULL);
    
}
// 指定回调方法

- (void)image: (UIImage *) image didFinishSavingWithError: (NSError *) error contextInfo: (void *) contextInfo

{
    
    NSString *msg = nil ;
    
    if(error != NULL){
        
        msg = @"保存图片失败" ;
        
    }else{
        
        msg = @"保存图片成功" ;
//        保存成功后添加到footview
        [self addSeceneImage:image];
        
    }
    
    
}
//截图功能

-(UIImage *)captureImageFromView:(UIView *)view

{
    
    CGRect screenRect = [view bounds];
    
    UIGraphicsBeginImageContext(screenRect.size);
    
    CGContextRef ctx = UIGraphicsGetCurrentContext();
    
    [view.layer renderInContext:ctx];
    
    UIImage * image = UIGraphicsGetImageFromCurrentImageContext();
    
    UIGraphicsEndImageContext();
    
    return image;
    
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}



/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
