//
//  LuckyDrawViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/5.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "LuckyDrawViewController.h"
#import "LuckyDrawDetailsViewController.h"

@interface LuckyDrawViewController ()

@property (nonatomic,strong) UIViewController *currentVC;

/**
 指示线x约束
 */
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *instructionViewConstraint;

@end

@implementation LuckyDrawViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setupChildrenController];
}

#pragma mark - 添加未抽奖和已抽奖情况
- (void)setupChildrenController
{
    /// 未抽奖
    LuckyDrawDetailsViewController *notDrawControl = [[[self class] getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"LuckyDrawDetailsViewController"];
    [self addChildViewController:notDrawControl];
    notDrawControl.drawValue = 1;
    self.currentVC = notDrawControl;
    /// 已抽奖
    LuckyDrawDetailsViewController *usedDrawControl = [[[self class] getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"LuckyDrawDetailsViewController"];
    usedDrawControl.drawValue = 2;
    [self addChildViewController:usedDrawControl];
    [self.backGroundView addSubview:notDrawControl.view];
}

#pragma mark - 布局
- (void)viewDidLayoutSubviews
{
    LuckyDrawDetailsViewController *notDrawControl = self.childViewControllers[0];
    notDrawControl.view.frame = CGRectMake(0, 0, self.backGroundView.mj_w, self.backGroundView.mj_h);

    LuckyDrawDetailsViewController *usedDrawControl = self.childViewControllers[1];
    usedDrawControl.view.frame = CGRectMake(0, 0, self.backGroundView.mj_w, self.backGroundView.mj_h);
}


#pragma mark - 切换未抽奖和已抽奖
- (void)switchPaymentsVCAndWithdrawalVC:(UIViewController *)newViewController
{
    [self transitionFromViewController:self.currentVC toViewController:newViewController duration:0.5 options:UIViewAnimationOptionTransitionNone animations:nil completion:^(BOOL finished) {
        if (finished) {
            [self.backGroundView addSubview:newViewController.view];
            self.currentVC = newViewController;
        }
    }];
}

#pragma mark - 切换ContentController
- (IBAction)paymentsButtonAndWithdrawalButtonClick:(UIButton *)sender {
    
    switch (sender.tag) {
        case 100:
        {
            self.usedDrawButton.selected = NO;
            
        }
            break;
        case 101:
        {
            self.notDrawButton.selected = NO;
        }
            break;
            
        default:
            break;
    }
    sender.selected = YES;
    [self setupInstructionsViewOrigin:sender];
    [self switchPaymentsVCAndWithdrawalVC:self.childViewControllers[sender.tag-100]];
}

#pragma mark - 设置指示线的位置
- (void)setupInstructionsViewOrigin:(UIButton *)sender
{
    self.instructionViewConstraint.constant = sender.x+16;
    [UIView animateWithDuration:0.5 delay:0.1f usingSpringWithDamping:0.5f initialSpringVelocity:0.5f options:UIViewAnimationOptionCurveEaseInOut animations:^{
        [self.view layoutIfNeeded];
    } completion:nil];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

@end
