//
//  CustomImageBackView.m
//  Lighting
//
//  Created by 曹云霄 on 2016/12/8.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CustomImageBackView.h"

@implementation CustomImageBackView



- (void)awakeFromNib
{
    [super awakeFromNib];
    CGFloat width = 150;
    CGFloat interval = 15;
    for (int i=0; i<3; i++) {
        UIImageView *imageView = [[UIImageView alloc] initWithFrame:CGRectMake(i*width+i*interval, 0, width, width)];
        imageView.userInteractionEnabled = YES;
        imageView.tag = i;
        [imageView addGestureRecognizer:[[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(TapClickAction:)]];
        [self addSubview:imageView];
        if (i == 2) {
            UILabel *instruction = [[UILabel alloc] initWithFrame:CGRectMake(width-50, width-15, 50, 15)];
            instruction.text = @"共4张";
            instruction.font = [UIFont systemFontOfSize:10];
            instruction.textColor = [UIColor whiteColor];
            instruction.textAlignment = NSTextAlignmentCenter;
            instruction.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.3];
            [imageView addSubview:instruction];
        }
    }
}

#pragma mark - 更新View
- (void)setImageArray:(NSArray<TOAttachmentEntity *> *)imageArray
{
    _imageArray = imageArray;
    for (int i=0;i<self.subviews.count;i++) {
        id object = self.subviews[i];
        if ([object isKindOfClass:[UIImageView class]]) {
            UIImageView *imageView = (UIImageView *)object;
            TOAttachmentEntity *entity = [_imageArray objectAtIndex_opple:i];
            imageView.hidden = !entity;
            [imageView sd_setImageWithURL:[NSURL URLWithString:entity.fileUrl] placeholderImage:REPLACEIMAGE];
            if (i == 2) {
                for (id obj in imageView.subviews) {
                    if ([obj isKindOfClass:[UILabel class]]) {
                        UILabel *label = (UILabel *)obj;
                        label.text = [NSString stringWithFormat:@"共%ld张",_imageArray.count];
                    }
                }
            }
        }
    }
}

#pragma mark - 单击事件
- (void)TapClickAction:(UITapGestureRecognizer *)sender
{
    if ([self.delegate respondsToSelector:@selector(tapImageViewWithIndex:withCellIndex:)]) {
        [self.delegate tapImageViewWithIndex:sender.view.tag withCellIndex:self.indexPath];
    }
}






@end
