//
//  CustomPromotionModel.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/15.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CustomPromotionModel.h"
#import "PromotionLuckyDrawModel.h"
#import "PromotionalGoodsModel.h"
#import "PromotionalDeductionModel.h"
#import "PromotionWeChatCardModel.h"

@implementation CustomPromotionModel


- (instancetype)initCustomPromotionModel:(JSONModel *)model
{
    if (self = [super init]) {
            //微信卡劵
        if ([model isMemberOfClass:[PromotionWeChatCardModel class]]) {
            PromotionWeChatCardModel *weChatModel = (PromotionWeChatCardModel *)model;
            self.descriptionString = weChatModel.descriptionString;
            self.type = weChatModel.type;
            self.body = weChatModel.body;
            self.conflicts = weChatModel.conflicts;
            self.priority = weChatModel.priority;
        }else if ([model isMemberOfClass:[PromotionalDeductionModel class]]) {
            //抵扣
            PromotionalDeductionModel *deductionModel = (PromotionalDeductionModel *)model;
            self.descriptionString = deductionModel.descriptionString;
            self.type = deductionModel.type;
            self.body = deductionModel.body;
            self.conflicts = deductionModel.conflicts;
            self.priority = deductionModel.priority;
        }else if ([model isMemberOfClass:[PromotionLuckyDrawModel class]]) {
            //抽奖
            PromotionLuckyDrawModel *drawModel = (PromotionLuckyDrawModel *)model;
            self.descriptionString = drawModel.descriptionString;
            self.type = drawModel.type;
            self.body = drawModel.body;
            self.conflicts = drawModel.conflicts;
            self.priority = drawModel.priority;
        }else if ([model isMemberOfClass:[PromotionalGoodsModel class]]) {
            //送商品
            PromotionalGoodsModel *goodsModel = (PromotionalGoodsModel *)model;
            self.descriptionString = goodsModel.descriptionString;
            self.type = goodsModel.type;
            self.body = goodsModel.body;
            self.conflicts = goodsModel.conflicts;
            self.priority = goodsModel.priority;
        }
    }
    return self;
}

@end
