//
//  ClientdetailsViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/3.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ClientdetailsViewController.h"
#import "ClientShoppingCarViewController.h"
#import "OrderRecordViewController.h"

@interface ClientdetailsViewController ()<DZNEmptyDataSetSource,DZNEmptyDataSetDelegate>

/**
 *  当前控制器
 */
@property (nonatomic,strong) BaseViewController *currentVC;

/**
 *  购物袋
 */
@property (nonatomic,strong) ClientShoppingCarViewController *shoppingCar;

/**
 *  订单记录
 */
@property (nonatomic,strong) OrderRecordViewController *orderRecord;

@end

@implementation ClientdetailsViewController


- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
    [self addChildViewController];
}


#pragma mark -UI
- (void)uiConfigAction
{
    //圆角
    self.shoppingAndRecordBackview.layer.masksToBounds = YES;
    self.shoppingAndRecordBackview.layer.cornerRadius = kCornerRadius;
    self.shoppingBagButton.layer.masksToBounds = YES;
    self.shoppingBagButton.layer.cornerRadius = kCornerRadius;
    self.orderRecordButton.layer.masksToBounds = YES;
    self.orderRecordButton.layer.cornerRadius = kCornerRadius;
    self.setupButton.layer.masksToBounds = YES;
    self.setupButton.layer.cornerRadius = kCornerRadius;
    
    //默认选中购物袋
    self.shoppingBagButton.selected = YES;
    self.shoppingBagButton.backgroundColor = [UIColor whiteColor];
    
    //赋值
    [self.customerHeader sd_setImageWithURL:[NSURL URLWithString:self.model.picture] placeholderImage:ReplaceImage];
    self.customerName.text = self.model.name;
    self.customerPhoneNumber.text = self.model.mobile;
    self.companyName.text = self.model.company;
    self.customerLocation.text = self.model.address;
    self.setupButton.selected = self.model.selectedState;
    [self.setupButton setTitle:self.model.selectedState?@"退出当前客户":@"设为当前客户" forState:UIControlStateNormal];
}

#pragma mark - 添加子视图
- (void)addChildViewController
{
    self.shoppingCar = [[[self class] getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"ClientShoppingCarViewController"];
    self.shoppingCar.model = self.model;
    [self addChildViewController:self.shoppingCar];
    self.currentVC = self.shoppingCar;
    [self.controllerBackgroundView addSubview:self.shoppingCar.view];
    
    self.orderRecord = [[[self class] getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"OrderRecordViewController"];
    [self addChildViewController:self.orderRecord];
    self.orderRecord.model = self.model;
}

#pragma mark - 设置frame
- (void)viewDidLayoutSubviews
{
    self.currentVC.view.frame = CGRectMake(0, self.shoppingAndRecordBackview.bottom, self.controllerBackgroundView.width, self.controllerBackgroundView.height-self.shoppingAndRecordBackview.bottom);
    self.orderRecord.view.frame = CGRectMake(0, self.shoppingAndRecordBackview.bottom, self.controllerBackgroundView.width, self.controllerBackgroundView.height-self.shoppingAndRecordBackview.bottom);
}

#pragma mark - 切换子视图
- (void)switchChildView:(BaseViewController *)controller
{
    WS(weakSelf);
    [self transitionFromViewController:self.currentVC toViewController:controller duration:0.5 options:UIViewAnimationOptionTransitionNone animations:nil completion:^(BOOL finished) {
        if (finished) {
            [weakSelf.controllerBackgroundView addSubview:controller.view];
            weakSelf.currentVC = controller;
        }
    }];
}

#pragma mark -设为当前的客户
- (IBAction)SetupcurrentUserButtonClick:(UIButton *)sender {
   
    if (self.CurrentUserBlock) {
        self.CurrentUserBlock(_cellindex,sender.currentTitle);
    }
     [sender setTitle:sender.selected?@"设为当前客户":@"退出当前客户" forState:UIControlStateNormal];
     sender.selected = !sender.selected;
}


#pragma mark -购物袋
- (IBAction)ShoppingbagButtonClick:(UIButton *)sender {
    
    sender.backgroundColor = [UIColor whiteColor];
    sender.selected = YES;
    self.orderRecordButton.selected = NO;
    self.orderRecordButton.backgroundColor = kMainBlueColor;
    [self switchChildView:self.shoppingCar];
}

#pragma mark -订单记录
- (IBAction)OrderrecordButtonClick:(UIButton *)sender {
    
    sender.backgroundColor = [UIColor whiteColor];
    sender.selected = YES;
    self.shoppingBagButton.selected = NO;
    self.shoppingBagButton.backgroundColor = kMainBlueColor;
    [self switchChildView:self.orderRecord];
}



@end
