//
//  CardCollectionViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 2016/10/19.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CardCollectionViewCell.h"

@implementation CardCollectionViewCell


- (void)awakeFromNib
{
    [super awakeFromNib];
    self.layer.shadowColor = [UIColor grayColor].CGColor;
    self.layer.shadowRadius = 4;
    self.layer.shadowOpacity = 0.3;
    self.layer.shadowOffset = CGSizeMake(-1, -1);
    self.layer.masksToBounds = NO;
}


- (void)setCardmodel:(TOJingdongEcardEntity *)Cardmodel
{
    _Cardmodel = Cardmodel;
    self.backgroundImageView.image = [BaseViewController getCorrespondingPictures:_Cardmodel.denomation];
    self.cardNumberLabel.text = [NSString stringWithFormat:@"卡号:   %@",_Cardmodel.cardNumber];
    self.cardPasswordLabel.text = [NSString stringWithFormat:@"密码:   %@",_Cardmodel.cardPassword];

    NSString *totalString = [NSString stringWithFormat:@"%ld元",_Cardmodel.denomation];
    NSMutableAttributedString *attributedString = [[NSMutableAttributedString alloc]initWithString:totalString];
    [attributedString addAttribute:NSFontAttributeName value:[UIFont fontWithName:@"HelveticaNeue-Bold" size:22] range:NSMakeRange(0, totalString.length-1)];
    self.self.amountLabel.attributedText = attributedString;
    
    // 判断状态
    BOOL isUsed = [_Cardmodel.state isEqualToString:USED];
    BOOL isActived = [_Cardmodel.state isEqualToString:ACTIVED];
    BOOL isDispensed = [_Cardmodel.state isEqualToString:DISPENSED];
    if (isDispensed) {
        self.usedImageView.hidden = YES;
        self.maskImageView.hidden = NO;
        self.useingButton.hidden = NO;
    }
    if (isActived) {
        self.usedImageView.hidden = YES;
        self.maskImageView.hidden = NO;
        self.useingButton.hidden = NO;
    }
    if (isUsed) {
        self.maskImageView.hidden = YES;
        self.useingButton.hidden = YES;
        self.usedImageView.hidden = NO;
    }
}

















@end
