//
//  SceneViewController.h
//  Lighting
//
//  Created by 曹云霄 on 16/6/1.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "BaseViewController.h"

/**
 *  选中场景或者商品回传
 */
@protocol AddImagesDelegate <NSObject>

@required

//增加图片
- (void)SelectedImageswithModel:(JSONModel *)model withisScene:(BOOL)isScene returnResponse:(void(^)(BOOL boolValue))isThere;
//刷新
- (void)RefreshSceneAndProduct:(BOOL)isScene;
//删除图片
@end


@interface SceneViewController : BaseViewController



/**
 *  场景或商品列表
 */
@property (weak, nonatomic) IBOutlet UICollectionView *sceneOrProductClollectionView;


/**
 * UICollectionViewLayout
 */
@property (weak, nonatomic) IBOutlet UICollectionViewFlowLayout *collectionViewLayout;



/************************筛选条件*****************************/


/**
 * 筛选tableview
 */
@property (weak, nonatomic) IBOutlet UITableView *screeningTableView;

/**
 *  文本
 */
@property (weak, nonatomic) IBOutlet UILabel *titleLabe;


/**
 *  风格
 */
@property (weak, nonatomic) IBOutlet UIButton *styleButton;


/**
 * 类型
 */
@property (weak, nonatomic) IBOutlet UIButton *typeButton;


/**
 *  空间
 */
@property (weak, nonatomic) IBOutlet UIButton *spaceButton;


/**
 *  材质
 */
@property (weak, nonatomic) IBOutlet UIButton *materialButton;


/**
 *  价格
 */
@property (weak, nonatomic) IBOutlet UIButton *priceButton;


/**
 *  拦截点击事件(列表背景)
 */
@property (weak, nonatomic) IBOutlet UIView *clickEventView;


/**
 *  tableview阴影背景
 */
@property (weak, nonatomic) IBOutlet UIView *myTableViewBackView;

/**
 *  产品模块搜索框
 */
@property (weak, nonatomic) IBOutlet UITextField *searchProductField;

/**
 *  搜索框背景
 */
@property (weak, nonatomic) IBOutlet UIView *searchBackView;


/**
 * 选中场景或商品，动画终点坐标
 */
@property (nonatomic,assign) CGPoint endAnimationPoint;


/**
 *  选中商品回传
 */
@property (nonatomic,weak) id<AddImagesDelegate> delegate;

/**
 *  dismiss回传
 */
@property (nonatomic,copy) void(^dismissBlock)();

@end
