//
//  screeningSecondView.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/8.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "screeningSecondView.h"
#import "ScreeningFirstCollectionViewCell.h"
#import "ScreeningSecondCollectionReusableView.h"


#define WIDTH self.screeningCollectionView.frame.size.width

@implementation screeningSecondView

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/




- (void)awakeFromNib
{
//    [self uiConfigAction];
}


#pragma mark -获取数据
- (void)setDatasArray:(NSArray *)datasArray
{
    _datasArray = datasArray;
    [self uiConfigAction];
    [self.screeningTableview reloadData];
    [self.screeningCollectionView reloadData];
}


#pragma mark - 布局
- (void)uiConfigAction
{
    
    self.screeningTableview.delegate = self;
    self.screeningTableview.dataSource = self;
    self.screeningTableview.backgroundColor = [UIColor grayColor];
    [self.screeningTableview registerClass:[UITableViewCell class] forCellReuseIdentifier:@"tableviewcell"];
    self.screeningLayout.itemSize = CGSizeMake((WIDTH-127)/3, 35);
    self.screeningLayout.minimumLineSpacing = 30;
    self.screeningLayout.minimumInteritemSpacing = 10;
    self.screeningLayout.sectionInset = UIEdgeInsetsMake(20, 30, 20, 30);
    [self.screeningCollectionView registerClass:[ScreeningFirstCollectionViewCell class] forCellWithReuseIdentifier:@"cell"];
    [self.screeningCollectionView registerClass:[ScreeningSecondCollectionReusableView class] forSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:@"screeningcell"];
    self.screeningCollectionView.dataSource = self;
    self.screeningCollectionView.delegate = self;
    self.screeningCollectionView.alwaysBounceVertical = YES;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"tableviewcell" forIndexPath:indexPath];
    cell.textLabel.text = @"全部";
    cell.selectedBackgroundView.backgroundColor = [UIColor whiteColor];
    cell.backgroundColor = [UIColor grayColor];
    cell.textLabel.textAlignment = NSTextAlignmentCenter;
    return cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 5;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 55;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{

    if ([self.delegate respondsToSelector:@selector(tableSelectedindex:)]) {
        
        [self.delegate tableSelectedindex:indexPath.row];
    }
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    ScreeningFirstCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"cell" forIndexPath:indexPath];
    cell.titleLabe.text = [self.datasArray objectAtIndex_opple:indexPath.item];
    return cell;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.datasArray.count;
}



- (UICollectionReusableView *)collectionView:(UICollectionView *)collectionView viewForSupplementaryElementOfKind:(NSString *)kind atIndexPath:(NSIndexPath *)indexPath
{
    ScreeningSecondCollectionReusableView *cell = [collectionView dequeueReusableSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:@"screeningcell" forIndexPath:indexPath];
    return cell;
}


- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout referenceSizeForHeaderInSection:(NSInteger)section{

    return CGSizeMake(self.screeningCollectionView.frame.size.width, 75);
}





#pragma mark -筛选结果点击
- (IBAction)ScreeningResultButtonClick:(UIButton *)sender {
    
    
}
























@end
