
//
//  CustomTabbarController.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/27.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CustomTabbarController.h"
#import "Toolview.h"
#import "AppDelegate.h"
#import "FollowHeartViewController.h"
#import "SceneLibraryViewController.h"
#import "ProductLibraryViewController.h"
#import "CustomerManagementViewController.h"
#import "AboutViewController.h"
#import "AllCustomerViewController.h"
#import "CustomerOrderViewController.h"
#import "UserViewController.h"
#import "ChangePasswordViewController.h"


@interface CustomTabbarController ()<TabbarButtonClickdelegate,ChangpasswordDelegate,CancelButtondelegate>

@property (nonatomic,strong) NSArray *identifierArray;
@property (nonatomic,strong) NSArray *controllerArray;

/**
 *  保存按钮引用
 */
@property (nonatomic,strong) UIButton *Newbutton;

@end

@implementation CustomTabbarController

/**
 *  UIStoryboard Identifier数组
 *
 *  @return NSArary
 */
- (NSArray *)identifierArray
{
    if (_identifierArray == nil) {
        
        _identifierArray = [NSArray arrayWithObjects:@"shopping",@"Client",@"followheart",@"scenelibrary",@"productlibrary",@"customermanager",@"allcustomer",@"customerorder",@"about", nil];
    }
    return _identifierArray
    ;
}


- (NSArray *)controllerArray
{
    if (_controllerArray == nil) {
        
        _controllerArray = [NSArray arrayWithObjects:@"ShoppingViewController",@"ClientViewController", nil];
    }
    return _controllerArray;
}


- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    

    [self uiConfigAction];
    [self addViewcontroller];
}

#pragma mark -UI
- (void)uiConfigAction
{
    self.tabBar.frame = CGRectMake(Zero, Zero, ScreenWidth, NavigationHeight);
    Toolview *toolview = [[Toolview alloc]initWithFrame:CGRectMake(Zero, Zero, ScreenWidth, NavigationHeight)];
    toolview.delegate = self;
    [self.tabBar addSubview:toolview];
    SHARED_APPDELEGATE.tabbar = self.tabBar;
}


#pragma mark -添加controller到viewControllers
- (void)addViewcontroller
{
    
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"StoryboardwithCYX" bundle:nil];
    ShoppingViewController *shoppingVC = [storyboard instantiateViewControllerWithIdentifier:[self.identifierArray objectAtIndex_opple:0]];
    ClientViewController *clientVC = [storyboard instantiateViewControllerWithIdentifier:[self.identifierArray objectAtIndex_opple:1]];
    FollowHeartViewController *followVC = [storyboard instantiateViewControllerWithIdentifier:[self.identifierArray objectAtIndex_opple:2]];
    SceneLibraryViewController *sceneVC = [storyboard instantiateViewControllerWithIdentifier:[self.identifierArray objectAtIndex_opple:3]];
    ProductLibraryViewController *productVC = [storyboard instantiateViewControllerWithIdentifier:[self.identifierArray objectAtIndex_opple:4]];
    CustomerManagementViewController *customerVC = [storyboard instantiateViewControllerWithIdentifier:[self.identifierArray objectAtIndex_opple:5]];
    AllCustomerViewController *allcustomerVC = [storyboard instantiateViewControllerWithIdentifier:[self.identifierArray objectAtIndex_opple:6]];
    CustomerOrderViewController *customerOrderVC = [storyboard instantiateViewControllerWithIdentifier:[self.identifierArray objectAtIndex_opple:7]];
    AboutViewController *aboutVC = [storyboard instantiateViewControllerWithIdentifier:[self.identifierArray objectAtIndex_opple:8]];
    
    
    UINavigationController *shoppingNav = [[UINavigationController alloc]initWithRootViewController:shoppingVC];
    UINavigationController *clientNav = [[UINavigationController alloc]initWithRootViewController:clientVC];
    UINavigationController *followNav = [[UINavigationController alloc]initWithRootViewController:followVC];
    UINavigationController *sceneNav = [[UINavigationController alloc]initWithRootViewController:sceneVC];
    UINavigationController *productNav = [[UINavigationController alloc]initWithRootViewController:productVC];
    UINavigationController *customerNav = [[UINavigationController alloc]initWithRootViewController:customerVC];
    UINavigationController *allcustomerNav = [[UINavigationController alloc]initWithRootViewController:allcustomerVC];
    UINavigationController *cutomerorderNav = [[UINavigationController alloc]initWithRootViewController:customerOrderVC];
    UINavigationController *aboutNav = [[UINavigationController alloc]initWithRootViewController:aboutVC];
    
    NSArray *vcArray = [NSArray arrayWithObjects:aboutNav,cutomerorderNav,allcustomerNav,customerNav,productNav,sceneNav,followNav,clientNav,shoppingNav, nil];
    self.viewControllers = vcArray;
    self.selectedIndex = 7;
}


#pragma mark -移除系统自带的UITabBarButton
- (void)viewWillLayoutSubviews {
    [super viewWillLayoutSubviews];
    
    for (UIView *view in self.tabBar.subviews) {
        
        if ([view isKindOfClass:NSClassFromString(@"UITabBarButton")]) {
            [view removeFromSuperview];
        }
    }
}


#pragma amrk -TabbarButtonClickdelegate代理
- (void)ButtonClickAction:(NSInteger)Buttontag withButton:(UIButton *)button
{
    _Newbutton = button;
    switch (Buttontag) {
            
            //右侧视图
        case 100:
            
            [SHARED_APPDELEGATE.mmdrawer toggleDrawerSide:MMDrawerSideRight animated:YES completion:nil];
            
            break;
            
            //某某用户
        case 101:
            
        {
            UserViewController *userVC = [[UserViewController alloc]init];
            userVC.delegate = self;
            userVC.preferredContentSize = CGSizeMake(260, 170);
            userVC.modalPresentationStyle = UIModalPresentationPopover;
            UIPopoverPresentationController *pop = userVC.popoverPresentationController;
            pop.permittedArrowDirections = UIPopoverArrowDirectionAny;
            pop.sourceView = userVC.view;
            pop.barButtonItem = [[UIBarButtonItem alloc]initWithCustomView:button];
            [self presentViewController:userVC animated:YES completion:nil];
        }
            
            break;
            
            //我的客户
        case 102:
            
            self.selectedIndex = 7;
            
            break;
            
            //购物车
        case 103:
            
             self.selectedIndex = 8;
            
            break;
            
        default:
            break;
    }
}

#pragma mark -修改密码点击
- (void)changPasswordButtonClick
{
    [self dismissViewControllerAnimated:NO completion:^{
        
        ChangePasswordViewController *changpassword = [[ChangePasswordViewController alloc]init];
        changpassword.delegate = self;
        changpassword.preferredContentSize = CGSizeMake(260, 180);
        changpassword.modalPresentationStyle = UIModalPresentationPopover;
        UIPopoverPresentationController *pop = changpassword.popoverPresentationController;
        pop.permittedArrowDirections = UIPopoverArrowDirectionAny;
        pop.sourceView = changpassword.view;
        pop.barButtonItem = [[UIBarButtonItem alloc]initWithCustomView:_Newbutton];
        [self presentViewController:changpassword animated:YES completion:nil];
        
    }];
}



#pragma mark -取消按钮
- (void)cancelButtonClick
{
    [self dismissViewControllerAnimated:NO completion:^{
        
        UserViewController *userVC = [[UserViewController alloc]init];
        userVC.delegate = self;
        userVC.preferredContentSize = CGSizeMake(260, 170);
        userVC.modalPresentationStyle = UIModalPresentationPopover;
        UIPopoverPresentationController *pop = userVC.popoverPresentationController;
        pop.permittedArrowDirections = UIPopoverArrowDirectionAny;
        pop.sourceView = userVC.view;
        pop.barButtonItem = [[UIBarButtonItem alloc]initWithCustomView:_Newbutton];
        [self presentViewController:userVC animated:YES completion:nil];
        
    }];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
