//
//  GenerateOrdersViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/5.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "GenerateOrdersViewController.h"
#import "GenerateOrdersTableViewCell.h"
#import "GenerateOrdersModifyTableViewCell.h"
#import "PersonInformationTableViewCell.h"
#import "CommodityListTableViewCell.h"
#import "AllpriceTableViewCell.h"
#import "AddaddressViewController.h"
#import "ModifyShippingAddressView.h"
#import "AppDelegate.h"
#import "OrderdetailsViewController.h"
#import "AddressViewController.h"
@interface GenerateOrdersViewController ()<UITableViewDelegate,UITableViewDataSource>

/**
 *  增加或者修改地址
 */
@property (nonatomic,strong) ModifyShippingAddressView *addressView;



@property (nonatomic,strong) UIView *Tabbarview;
@end

@implementation GenerateOrdersViewController





- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
}

#pragma mark -UI
- (void)uiConfigAction
{
    self.generateOrderTableview.dataSource = self;
    self.generateOrderTableview.delegate = self;
    self.generateOrderTableview.tableFooterView = [UIView new];
}




- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    if (indexPath.section == 0 && indexPath.row == 0) {
        
        PersonInformationTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"secondcell" forIndexPath:indexPath];
        return cell;
    }
    else if (indexPath.section == 1)
    {
        if (indexPath.row == 1) {
            
            GenerateOrdersModifyTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"Modifycell" forIndexPath:indexPath];
            return cell;
        }
        GenerateOrdersTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"consigneecell" forIndexPath:indexPath];
        return cell;
    }
    else if (indexPath.section == 2)
    {

        if (indexPath.row == 1) {
            
            AllpriceTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"sixthcell" forIndexPath:indexPath];
            return cell;
        }
        CommodityListTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"fourthcell" forIndexPath:indexPath];
        
        return cell;
    }
    return nil;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    switch (section) {
        case 0:
        {
            return 1;
        }
            break;
        case 1:
        {
            return 2;
        }
            break;
        case 2:
        {
            return 2;
        }
            break;
            
        default:
            break;
    }
    return 0;
}


- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.section) {
        case 0:
        {
            return 160;
        }
            break;
        case 1:
        {
            return 56;
        }
            break;
        case 2:
        {
            if (indexPath.row == 1) {
                
                return 50;
            }
            return 80;
        }
            break;
            
        default:
            break;
    }
    return 0;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    switch (section) {
        case 0:
        {
            return 0;
        }
            break;
        case 1:
        {
            return 10;
        }
            break;
        case 2:
        {
            return 44;
        }
            break;
            
        default:
            break;
    }
    return 0;
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    UIView *view = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, 44)];
    view.backgroundColor = [UIColor redColor];
    return view;
}



- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 3;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [self CreateModifyShippingView];
}


#pragma mark -新增或者修改收货地址
- (void)CreateModifyShippingView
{
    
    AddressViewController *address = [[AddressViewController alloc]init];
    address.preferredContentSize = CGSizeMake(315, 320);
    address.modalPresentationStyle = UIModalPresentationFormSheet;
    UIPopoverPresentationController *pop = address.popoverPresentationController;
    pop.permittedArrowDirections = UIPopoverArrowDirectionAny;
    pop.sourceView = address.view;
    [self presentViewController:address animated:YES completion:nil];
}




#pragma mark -生成订单
- (IBAction)CreateOrderButtonClick:(UIButton *)sender {
    
    OrderdetailsViewController *orderDetails = [[self getStoryboardWithName] instantiateViewControllerWithIdentifier:@"orderdetails"];
    [self.navigationController pushViewController:orderDetails animated:YES];
}


#pragma mark -返回购物车

- (IBAction)BackShoppingBagsButtonClick:(UIButton *)sender {
    
    [self.navigationController popViewControllerAnimated:YES];
}










- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
