//
//  ScreeningSecondCollectionReusableView.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/10.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ScreeningSecondCollectionReusableView.h"


#define WIDTH self.frame.size.width
@implementation ScreeningSecondCollectionReusableView



- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        [self uiConfigAction];
    }
    return self;
}


#pragma mark -UI
- (void)uiConfigAction
{
    self.alltitleButton = [UIButton buttonWithType:UIButtonTypeSystem];
    self.alltitleButton.layer.masksToBounds = YES;
    self.alltitleButton.layer.cornerRadius = kCornerRadius;
    [self.alltitleButton setTitle:@"全部" forState:UIControlStateNormal];
    [self addSubview:self.alltitleButton];
    self.alltitleButton.titleLabel.font = [UIFont systemFontOfSize:12];
    [self.alltitleButton setBackgroundColor:kMainBlueColor];
    [self.alltitleButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    [self.alltitleButton mas_makeConstraints:^(MASConstraintMaker *make) {
        
        make.size.mas_equalTo(CGSizeMake((WIDTH-127)/3, 35));
        make.right.equalTo(self.mas_right).offset(-30);
        make.top.equalTo(self.mas_top).offset(20);
    }];
    
    
    
}

@end
