//
//  ProductDetailsViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/4.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ProductDetailsViewController.h"
#import "ProductDetailsTableViewCell.h"
#import "ProductDetailsHeaderView.h"


@interface ProductDetailsViewController ()<UITableViewDelegate,UITableViewDataSource>

@property (nonatomic,strong) ProductDetailsHeaderView *headerView;

@end

@implementation ProductDetailsViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
}

#pragma mark -UI
- (void)uiConfigAction
{
    self.productDetilsTableview.dataSource = self;
    self.productDetilsTableview.delegate = self;
    [self CreateHeaderView];
}


#pragma mark -头部视图
- (void)CreateHeaderView
{
    self.headerView = [[[NSBundle mainBundle] loadNibNamed:@"ProductDetailsHeaderView" owner:self options:nil] lastObject];
    self.productDetilsTableview.tableHeaderView = self.headerView;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    ProductDetailsTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"productDetailscell" forIndexPath:indexPath];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    return cell;
    
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 1;
}


- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 170;
}


- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 2;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 50;
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    UIView *headerView = [[UIView alloc]initWithFrame:CGRectMake(0, 2, ScreenWidth, 46)];
    headerView.backgroundColor = [UIColor grayColor];
    UILabel *titleLabe = [[UILabel alloc]initWithFrame:CGRectMake(50, 15, 200, 20)];
    titleLabe.textColor = [UIColor redColor];
    titleLabe.font = [UIFont systemFontOfSize:12];
    titleLabe.text = section?@"商品参数":@"图文详情";
    [headerView addSubview:titleLabe];
    return headerView;
}





- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
