//
//  ClientdetailsViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/3.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ClientdetailsViewController.h"
#import "ClientDetailsTableViewCell.h"
#import "OrderTableViewCell.h"
#import "OrderdetailsViewController.h"

@interface ClientdetailsViewController ()<UITableViewDelegate,UITableViewDataSource>

/**
 *  客户详情
 */
@property (weak, nonatomic) IBOutlet UITableView *ClientdetailsTableview;



@end

@implementation ClientdetailsViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    [self uiConfigAction];
}


#pragma mark -UI
- (void)uiConfigAction
{
    self.ClientdetailsTableview.delegate = self;
    self.ClientdetailsTableview.dataSource = self;
    
    //圆角
    self.shoppingAndRecordBackview.layer.masksToBounds = YES;
    self.shoppingAndRecordBackview.layer.cornerRadius = kCornerRadius;
    self.shoppingBagButton.layer.masksToBounds = YES;
    self.shoppingBagButton.layer.cornerRadius = kCornerRadius;
    self.orderRecordButton.layer.masksToBounds = YES;
    self.orderRecordButton.layer.cornerRadius = kCornerRadius;
    
    //默认选中购物袋
    self.shoppingBagButton.selected = YES;
    self.shoppingBagButton.backgroundColor = [UIColor whiteColor];
    
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (self.shoppingBagButton.selected) {
        
        ClientDetailsTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"ClientDetails" forIndexPath:indexPath];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;
        
    }else if (self.orderRecordButton.selected)
    {
        OrderTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"ordercell" forIndexPath:indexPath];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return  cell;
    }
    return  nil;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 20;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (self.shoppingBagButton.selected) {
        
        return 100;
    }
    else if (self.orderRecordButton.selected)
    {
        return 200;
    }
    return 0;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"StoryboardwithCYX" bundle:nil];
    OrderdetailsViewController *orderdetails = [storyboard instantiateViewControllerWithIdentifier:@"orderdetails"];
    [self.navigationController pushViewController:orderdetails animated:YES];
    
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


#pragma mark -设为当前的客户
- (IBAction)SetupcurrentUserButtonClick:(UIButton *)sender {
    
    
}


#pragma mark -购物袋
- (IBAction)ShoppingbagButtonClick:(UIButton *)sender {
    
    
    sender.backgroundColor = [UIColor whiteColor];
    sender.selected = YES;
    self.orderRecordButton.selected = NO;
    self.orderRecordButton.backgroundColor = kMainBlueColor;
    [self.ClientdetailsTableview reloadData];
}

#pragma mark -订单记录
- (IBAction)OrderrecordButtonClick:(UIButton *)sender {
    
    
    sender.backgroundColor = [UIColor whiteColor];
    sender.selected = YES;
    self.shoppingBagButton.selected = NO;
    self.shoppingBagButton.backgroundColor = kMainBlueColor;
    [self.ClientdetailsTableview reloadData];
    
}










/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
