//
//  ClientViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/28.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ClientViewController.h"
#import "InformationTableViewCell.h"
#import "ClientdetailsViewController.h"
@interface ClientViewController ()<UITableViewDelegate,UITableViewDataSource,UITextFieldDelegate>

@end

@implementation ClientViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    [self uiConfigAction];
}


- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    // 禁用 iOS7 返回手势
    if ([self.navigationController respondsToSelector:@selector(interactivePopGestureRecognizer)]) {
        self.navigationController.interactivePopGestureRecognizer.enabled = NO;
    }
}

- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    
    // 开启
    if ([self.navigationController respondsToSelector:@selector(interactivePopGestureRecognizer)]) {
        self.navigationController.interactivePopGestureRecognizer.enabled = YES;
    }
}


#pragma mark -布局
- (void)uiConfigAction
{
    //圆角
    self.customerNameBack.layer.masksToBounds = YES;
    self.customerNameBack.layer.cornerRadius = kCornerRadius;
    self.phoneNumberBack.layer.masksToBounds = YES;
    self.phoneNumberBack.layer.cornerRadius = kCornerRadius;
    self.companyNameBack.layer.masksToBounds = YES;
    self.companyNameBack.layer.cornerRadius = kCornerRadius;
    self.customerAddressBack.layer.masksToBounds = YES;
    self.customerAddressBack.layer.cornerRadius = kCornerRadius;
    self.addpersonInformationButton.layer.masksToBounds = YES;
    self.addpersonInformationButton.layer.cornerRadius = kCornerRadius;
    self.changePersonInformationButton.layer.masksToBounds = YES;
    self.changePersonInformationButton.layer.cornerRadius = kCornerRadius;
    
    //隐藏更改客户按钮
    self.changePersonInformationButton.hidden = YES;
    
    
    //代理
    self.informationTableview.delegate = self;
    self.informationTableview.dataSource = self;
    self.searchPersonInformationField.delegate = self;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    InformationTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"information" forIndexPath:indexPath];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    return cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 20;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 100;
}


- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"StoryboardwithCYX" bundle:nil];
    ClientdetailsViewController *clientdetails = [storyboard instantiateViewControllerWithIdentifier:@"clientdetails"];
    [self.navigationController pushViewController:clientdetails animated:YES];
    
}


#pragma mark -添加客户信息

- (IBAction)addCustomerInformationORExit:(UIButton *)sender {
    
    if ([sender.currentTitle isEqualToString:@"退出当前客户"]) {
      
        self.customerNameField.text = nil;
        self.customerAddress.text = nil;
        self.phoneNumberField.text = nil;
        self.companyNameField.text = nil;
        self.changePersonInformationButton.hidden = YES;
        [sender setTitle:@"添加客户信息" forState:UIControlStateNormal];
        return;
    }
    [self addCustomerInformation];
}


#pragma mark -添加客户信息请求
- (void)addCustomerInformation
{
    [self.view endEditing:YES];
    if (self.customerNameField.text.length == 0) {
        
        [self ErrorMBProgressView:@"客户名不能为空"];
        return;
    }
    if (self.phoneNumberField.text.length == 0) {
        
        [self ErrorMBProgressView:@"手机号码不能为空"];
        return;
    }
    
    NSString *phoneNumber = self.phoneNumberField.text;
    if (![HENLENSONG isValidateMobile:phoneNumber]) {
        
        [self ErrorMBProgressView:@"手机号码格式不正确"];
        return;
    }
    
    //客户信息类
    TOConsumerEntity *customerEntity = [[TOConsumerEntity alloc]init];
    customerEntity.createName = self.customerNameField.text;
    customerEntity.mobile = self.phoneNumberField.text;
    customerEntity.address = self.customerAddress.text;
    customerEntity.name = self.companyNameField.text;
    
    [self CreateMBProgressHUDLoding];
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:[NSString stringWithFormat:@"%@%@",ServerAddress,@"/consumer/save"] WithRequestType:0 WithParameter:customerEntity WithReturnValueBlock:^(id returnValue) {
        
        [self RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            
            [self SuccessMBProgressView:returnValue[@"message"]];
            [self.addpersonInformationButton setTitle:@"退出当前客户" forState:UIControlStateNormal];
            self.changePersonInformationButton.hidden = NO;
            self.customerNameField.enabled = NO;
            self.customerAddress.enabled = NO;
            self.phoneNumberField.enabled = NO;
            self.companyNameField.enabled = NO;
        }
        else
        {
            [self ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        
        
        
    } WithFailureBlock:^(id error) {
        
        [self RemoveMBProgressHUDLoding];
        
    }];
}


#pragma mark -更改客户信息
- (IBAction)changeCustomerInformation:(UIButton *)sender {
    
    
    self.customerNameField.enabled = YES;
    self.customerAddress.enabled = YES;
    self.phoneNumberField.enabled = YES;
    self.companyNameField.enabled = YES;
    [self.customerNameField becomeFirstResponder];
    
}


#pragma mark -UITextFieldDelegate代理 ----搜索
- (BOOL)textFieldShouldReturn:(UITextField *)textField
{
    [self searchCustomerInforMation];
    return YES;
}


#pragma amrk -搜索客户信息
- (void)searchCustomerInforMation
{
    if (self.searchPersonInformationField.text.length == 0) {
        
        [self ErrorMBProgressView:@"搜索信息不能为空"];
        return;
    }

    [self CreateMBProgressHUDLoding];
    ConsumerQueryCondition *searchCustomer = [[ConsumerQueryCondition alloc]init];
    searchCustomer.nameEquals = self.searchPersonInformationField.text;
    searchCustomer.mobileEquals = self.searchPersonInformationField.text;
    searchCustomer.page.sort = @"lastVisitedTime";
    //request
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:[NSString stringWithFormat:@"%@%@",ServerAddress,@"/consumer/query"] WithRequestType:0 WithParameter:searchCustomer WithReturnValueBlock:^(id returnValue) {
        
        [self RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            
            ConsumerPageResult *result = [[ConsumerPageResult alloc]initWithDictionary:returnValue error:nil];
            NSLog(@"%@",result);
        }
        else
        {

        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        
        
        
    } WithFailureBlock:^(id error) {
        
        
        
    }];
    
    
    
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
