//
//  XBLoadingView.m
//  Lighting
//
//  Created by 曹云霄 on 2016/12/1.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "XBLoadingView.h"

@implementation XBLoadingView

/**
 显示普通加载框
 */
+ (void)showHUDViewWithDefault
{
    XBLoadingView *hud = [XBLoadingView showHUDAddedTo:SHARED_APPDELEGATE.window animated:YES];
    hud.animationType = MBProgressHUDAnimationZoom;
    hud.mode = MBProgressHUDModeIndeterminate;
    hud.color = [UIColor clearColor];
    hud.activityIndicatorColor = kMainBlueColor;
    hud.removeFromSuperViewOnHide = YES;
}

/**
 显示文本提示框
 
 @param text 提示信息
 */
+ (void)showHUDViewWithText:(NSString *)text
{
    [[self class] hideHUDViewWithDefault];
    XBLoadingView *hud = [XBLoadingView showHUDAddedTo:SHARED_APPDELEGATE.window animated:YES];
    hud.labelText = text;
    hud.margin = 20.f;
    hud.color = [[UIColor blackColor] colorWithAlphaComponent:0.5];
    hud.animationType = MBProgressHUDAnimationZoom;
    hud.mode = MBProgressHUDModeText;
    hud.removeFromSuperViewOnHide = YES;
    [hud hide:YES afterDelay:3.0f];
}

/**
 显示成功提示框
 
 @param text 提示信息
 */
+ (void)showHUDViewWithSuccessText:(NSString *)text completeBlock:(void (^)())finish
{
    XBLoadingView *hud = [XBLoadingView showHUDAddedTo:SHARED_APPDELEGATE.window animated:YES];
    hud.mode = MBProgressHUDModeCustomView;
    UIImage *image = [[UIImage imageNamed:@"Checkmark"] imageWithRenderingMode:UIImageRenderingModeAlwaysOriginal];
    hud.customView = [[UIImageView alloc] initWithImage:image];
    hud.color = [[UIColor blackColor] colorWithAlphaComponent:0.6];
    hud.labelFont = [UIFont systemFontOfSize:15];
    hud.labelText = text;
    [hud hide:YES afterDelay:3];
    if (finish) {
        finish = hud.completionBlock;
    }
}

/**
 显示进度框
 
 @param text 提示信息
 
 @return XBLoadingView
 */
+ (XBLoadingView *)showHUDViewProgressLabel:(NSString *)text
{
    XBLoadingView *hud = [XBLoadingView showHUDAddedTo:SHARED_APPDELEGATE.window animated:YES];
    hud.mode = MBProgressHUDModeDeterminate;
    hud.labelText = text;
    hud.labelFont = [UIFont systemFontOfSize:12];
    hud.removeFromSuperViewOnHide = YES;
    return hud;
}

/**
 隐藏加载框
 */
+ (void)hideHUDViewWithDefault
{
    [[self class] hideHUDForView:SHARED_APPDELEGATE.window animated:YES];
}

@end
