//
//  CustomWKWebViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/17.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CustomWKWebViewController.h"
#import <WebKit/WebKit.h>
@interface CustomWKWebViewController ()<WKNavigationDelegate,WKScriptMessageHandler,UIScrollViewDelegate>

@property (nonatomic,strong) WKWebView *webView;
@property (nonatomic,strong) WKWebViewConfiguration *config;
@property (nonatomic,strong) UIButton *dismissButton;

@end

@implementation CustomWKWebViewController

#pragma mark - lazy
- (WKWebViewConfiguration *)config
{
    if (!_config) {
        _config = [[WKWebViewConfiguration alloc]init];
        // 设置偏好设置
        _config.preferences = [[WKPreferences alloc] init];
        // 默认为0
        _config.preferences.minimumFontSize = 10;
        // 默认认为YES
        _config.preferences.javaScriptEnabled = YES;
        // 在iOS上默认为NO，表示不能自动通过窗口打开
        _config.preferences.javaScriptCanOpenWindowsAutomatically = NO;
        // 通过JS与webview内容交互
        _config.userContentController = [[WKUserContentController alloc] init];
        [_config.userContentController addScriptMessageHandler:self name:@"AppModel"];
    }
    return _config;
}

- (WKWebView *)webView
{
    if (!_webView) {
        _webView = [[WKWebView alloc] initWithFrame:self.view.bounds configuration:self.config];
        _webView.navigationDelegate = self;
        [self.view insertSubview:_webView atIndex:0];
    }
    return _webView;
}


- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self determineTheURLFileType];
    [self addDismissButton];
}

#pragma mark - 判断加载文件类型
- (void)determineTheURLFileType
{
    [self loadURLfileAction];
}

#pragma mark - 加载URL
- (void)loadURLfileAction
{
    NSSet *websiteDataTypes = [WKWebsiteDataStore allWebsiteDataTypes];
    NSDate *dateFrom = [NSDate dateWithTimeIntervalSince1970:0];
    [[WKWebsiteDataStore defaultDataStore] removeDataOfTypes:websiteDataTypes modifiedSince:dateFrom completionHandler:^{
        NSLog(@"清理缓存成功");
    }];
}

#pragma mark - 数据
- (void)setUrlString:(NSString *)urlString
{
    _urlString = urlString;
    [self.webView loadRequest:[NSURLRequest requestWithURL:[NSURL URLWithString:_urlString]]];
}

//#pragma mark - 加载PPT文件
//- (void)loadPPTfileAction
//{
//    [self.webView loadRequest:[NSURLRequest requestWithURL:[NSURL URLWithString:self.urlString]]];
//    self.webView.scrollView.scrollEnabled = NO;
//    self.webView.scrollView.pagingEnabled = YES;
//    self.webView.scrollView.delegate = self;
//    self.countdownLabel.text = @"10";
//    [[NSRunLoop currentRunLoop] addTimer:self.timer forMode:NSDefaultRunLoopMode];
//}
//
//- (void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView
//{
//    NSLog(@" end  %f",scrollView.contentOffset.y);
//    [[NSRunLoop currentRunLoop] addTimer:self.timer forMode:NSDefaultRunLoopMode];
//    self.countdownLabel.text = @"10";
//    self.webView.scrollView.scrollEnabled = NO;
//}
//
//#pragma mark - 浏览PPT倒计时
//- (void)timerAction
//{
//    NSInteger number = [self.countdownLabel.text integerValue];
//    if (number <= 0) {
//        self.webView.scrollView.scrollEnabled = YES;
//        self.countdownLabel.text = @"请翻页";
//        [self.timer invalidate];
//        self.timer = nil;
//    }else{
//        number --;
//        self.countdownLabel.text = [NSString stringWithFormat:@"%ld",number];
//    }
//}

#pragma mark - 添加删除按钮
- (void)addDismissButton
{
    self.dismissButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.view addSubview:self.dismissButton];
    [self.dismissButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(40);
        make.top.mas_equalTo(40);
        make.size.mas_equalTo(CGSizeMake(50, 50));
    }];
    [self.dismissButton setBackgroundImage:TCImage(@"1") forState:UIControlStateNormal];
    [self.dismissButton addTarget:self action:@selector(dismissButtonClick) forControlEvents:UIControlEventTouchUpInside];
}

#pragma mark - WKScriptMessageHandler
- (void)userContentController:(WKUserContentController *)userContentController didReceiveScriptMessage:(WKScriptMessage *)message
{
    if ([message.name isEqualToString:@"AppModel"]) {
        // 打印所传过来的参数，只支持NSNumber, NSString, NSDate, NSArray,
        // NSDictionary, and NSNull类型
       id json = [NSJSONSerialization JSONObjectWithData:[message.body[@"body"] dataUsingEncoding:NSUTF8StringEncoding] options:NSJSONReadingMutableContainers error:nil];
        if (json) {
            if ([json isKindOfClass:[NSDictionary class]]) {
                NSDictionary *resultDict = (NSDictionary *)json;
                if ([[resultDict allKeys] containsObject:@"click"]) {
                    self.dismissButton.enabled = NO;
                }else {
                    self.dismissButton.enabled = YES;
                    if (self.luckyDrawFinishBlock) {
                        self.luckyDrawFinishBlock(resultDict);
                    }
                }
            }
        }
    }
}

#pragma mark -dismiss
- (void)dismissButtonClick
{
    WS(weakSelf);
    [self dismissViewControllerAnimated:YES completion:^{
        if (weakSelf.dismissLuckyDrawController) {
            weakSelf.dismissLuckyDrawController();
        }
    }];
}

- (void)webView:(WKWebView *)webView didStartProvisionalNavigation:(null_unspecified WKNavigation *)navigation
{
    [XBLoadingView showHUDViewWithDefault];
}

- (void)webView:(WKWebView *)webView didFinishNavigation:(WKNavigation *)navigation
{
    [XBLoadingView hideHUDViewWithDefault];
}

- (void)webView:(WKWebView *)webView didFailNavigation:(WKNavigation *)navigation withError:(NSError *)error
{
    [XBLoadingView showHUDViewWithText:@"加载失败"];
    [self dismissViewControllerAnimated:YES completion:nil];
}




@end
