//
//  AirPrintManager.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/10.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "AirPrintManager.h"

@implementation AirPrintManager

/**
 打印URL订单
 
 @param data   数据源
 @param finish 完成
 @param failed 失败
 */
+ (void)printOrderWithdataSoure:(UIViewPrintFormatter *)data printSuccess:(void(^)())finish printError:(void(^)())failed
{
    UIPrintInteractionController *printControl = [UIPrintInteractionController sharedPrintController];
    UIPrintInfo *printInfo = [UIPrintInfo printInfo];
    printInfo.outputType = UIPrintInfoOutputGeneral;
    printInfo.jobName = @"订单明细";
    printInfo.duplex = UIPrintInfoDuplexShortEdge;
    printControl.printInfo = printInfo;
    printControl.showsPageRange = YES;
    printControl.printFormatter = data;
    void (^completionHandler)(UIPrintInteractionController *, BOOL, NSError *) = ^(UIPrintInteractionController *pic, BOOL completed, NSError *error) {
        if (completed)
        {
            // 执行成功后的处理
            finish();
        }
        else if (!completed && error)
        {
            // 执行失败后的处理
            failed();
        }
    };
    if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad) {
        [printControl presentAnimated:YES completionHandler:completionHandler];
    }
}


@end
