//
//  ScreeningView.h
//  Lighting
//
//  Created by 曹云霄 on 16/5/7.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>


/**
 *  右侧筛选菜单点击
 */
@protocol ScreeningButtonClickdelegate <NSObject>

@required

- (void)ScreeningButtonClick:(NSInteger)buttontag;

@end



@interface ScreeningView : UIView


/**
 *  风格按钮
 */
@property (weak, nonatomic) IBOutlet UIButton *styleButton;

/**
 *  类型按钮
 */
@property (weak, nonatomic) IBOutlet UIButton *typeButton;

/**
 *  空间按钮
 */
@property (weak, nonatomic) IBOutlet UIButton *spaceButton;

/**
 *  材质按钮
 */
@property (weak, nonatomic) IBOutlet UIButton *materialButton;


/**
 *  价格按钮
 */
@property (weak, nonatomic) IBOutlet UIButton *spriceButton;


/**
 *  背景View
 */
@property (weak, nonatomic) IBOutlet UIView *backgroundView;

/**
 *  筛选、分类切换
 */
@property (weak, nonatomic) IBOutlet UISegmentedControl *sortingSegmented;

/**
 *  阴影View
 */
@property (weak, nonatomic) IBOutlet UIView *shadowView;


/**
 *  代理
 */
@property (nonatomic,assign) id<ScreeningButtonClickdelegate> delegate;



/**
 *  选中按钮(其他设为未选中状态)
 */
@property (nonatomic,assign) NSInteger indexselected;









@end
