//
//  ProductCollectionViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/4.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ProductCollectionViewCell.h"

@implementation ProductCollectionViewCell






/**
 *  加入购物车点击
 */
- (IBAction)AddShoppingcarButtonClick:(UIButton *)sender {

    CGPoint carButtonCenter = self.productImageView.center;
    //把button在cell坐标转化为在tableView上的坐标
    CGPoint point = [self convertPoint:carButtonCenter toView:self.superview.window];
    
    //回调
    if (_ReturnCellCgpoint)
    {
        _ReturnCellCgpoint(point,_cellindex,self.productImageView.frame.size);
    }
}


- (void)setModel:(TOGoodsEntity *)model
{
    NSArray *imageArray = [model.pictures componentsSeparatedByString:@","];
    [self.productImageView sd_setImageWithURL:[NSURL URLWithString:[imageArray firstObject]] placeholderImage:REPLACEIMAGE];
    self.productPrice.text = [NSString stringWithFormat:@"￥%.2f",[model.tagPrice floatValue]];
    self.productParameter.text = model.name;
    self.specifications.text = [NSString stringWithFormat:@"%@(%@)",model.code,model.size];
}


@end
