
//
//  PrizeExchangeDetailsViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/22.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "PrizeExchangeDetailsViewController.h"
#import "PrizeExchangeBillTableViewCell.h"
#import "PrizeExchangeSectionTableViewCell.h"
#import "PrizeExchangeInformationTableViewCell.h"
#import "PrizeExchangeConsigneeTableViewCell.h"
#import "PrizeExchangeCourierTableViewCell.h"
#import "prizeOrderDetailsModel.h"

@interface PrizeExchangeDetailsViewController ()<UITableViewDelegate,UITableViewDataSource>


/**
 兑奖单详情
 */
@property (nonatomic,strong) prizeOrderDetailsModel *prizeBillResult;

/**
 section title Array
 */
@property (nonatomic,strong) NSMutableArray *sectionTitleArray;

@end

@implementation PrizeExchangeDetailsViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpTableView];
    [self getPrizeDetailsDataAction];
}

#pragma mark - UITableView
- (void)setUpTableView
{
    self.prizeExchangeDetailsTableView.tableFooterView = [UIView new];
    self.prizeExchangeDetailsTableView.sectionHeaderHeight = 60;
}

#pragma mark - 兑奖记录详情
- (void)getPrizeDetailsDataAction
{
    WS(weakSelf);
    [XBLoadingView showHUDViewWithDefault];;
    NSString *url = [NSString stringWithFormat:SERVERREQUESTURL(PRIZEBILLDETAILS),self.prizeBillNumber];
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:url WithRequestType:ONE WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            weakSelf.prizeBillResult = [[prizeOrderDetailsModel alloc]initWithDictionary:returnValue[@"data"] error:nil];
        }else {
            [XBLoadingView showHUDViewWithText:returnValue[@"message"]];
        }
        [weakSelf.prizeExchangeDetailsTableView reloadData];
    } WithFailureBlock:^(NSError *error) {
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}

#pragma mark - <UITableViewDelegate,UITableViewDataSource>
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.section) {
        case ExchangeBillInformation:
        {
            PrizeExchangeBillTableViewCell *billCell = [tableView dequeueReusableCellWithIdentifier:@"PrizeExchangeBillTableViewCell" forIndexPath:indexPath];
            billCell.billEntity = self.prizeBillResult.bill;
            return billCell;
        }
            break;
        case ReceivingInformation:
        {
            PrizeExchangeConsigneeTableViewCell *consigneeCell = [tableView dequeueReusableCellWithIdentifier:@"PrizeExchangeConsigneeTableViewCell" forIndexPath:indexPath];
            consigneeCell.consigneeEntity = self.prizeBillResult.bill;
            return consigneeCell;
        }
            break;
        case RewardInformation:
        {
            PrizeExchangeInformationTableViewCell *rewardCell = [tableView dequeueReusableCellWithIdentifier:@"PrizeExchangeInformationTableViewCell" forIndexPath:indexPath];
            rewardCell.giftDetailsArray = self.prizeBillResult.details;
            return rewardCell;
        }
            break;
        case LogisticsInformation:
        {
            PrizeExchangeCourierTableViewCell *logisticsCell = [tableView dequeueReusableCellWithIdentifier:@"PrizeExchangeCourierTableViewCell" forIndexPath:indexPath];
            logisticsCell.billEntity = self.prizeBillResult.bill;
            return logisticsCell;
        }
            break;
        default:
            break;
    }
    return nil;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return ONE;
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return self.sectionTitleArray.count;
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    PrizeExchangeSectionTableViewCell *headerView = [tableView dequeueReusableCellWithIdentifier:@"PrizeExchangeSectionTableViewCell"];
    headerView.sectionTitleLabel.text = self.sectionTitleArray[section];
    return headerView;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.section) {
        case ExchangeBillInformation:
        case ReceivingInformation:
            return 100;
            break;
        case RewardInformation:
        {
            return self.prizeBillResult.giftHeight;
        }
            break;
        case LogisticsInformation:
        {
            return 60;
        }
            break;
        default:
            break;
    }
    return 0;
}


#pragma mark - lazy
- (NSMutableArray *)sectionTitleArray
{
    if (!_sectionTitleArray) {
        _sectionTitleArray = [NSMutableArray arrayWithObjects:@"兑换单信息",@"收货信息",@"奖励信息", nil];
        if (self.isDelivery) {
            [_sectionTitleArray addObject:@"物流信息"];
        }
    }
    return _sectionTitleArray;
}



@end
