//
//  PaymentsDetailsTableViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/8/26.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "PaymentsDetailsTableViewController.h"

@interface PaymentsDetailsTableViewController ()

/**
 *  金额
 */
@property (weak, nonatomic) IBOutlet UILabel *amountLabel;

/**
 *  金额类型
 */
@property (weak, nonatomic) IBOutlet UILabel *amountTypeLabel;

/**
 *  时间
 */
@property (weak, nonatomic) IBOutlet UILabel *createTimeLabel;

/**
 *  流水号
 */
@property (weak, nonatomic) IBOutlet UILabel *serialNumberLabel;

/**
 *  余额
 */
@property (weak, nonatomic) IBOutlet UILabel *currentAmountLabel;

@end

@implementation PaymentsDetailsTableViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
    [self fillDataAction];
}

#pragma mark - UI
- (void)uiConfigAction
{
    self.tableView.tableFooterView = [UIView new];
}

#pragma mark - 填充数据
- (void)fillDataAction
{
    NSString *string = ([self.model.amount floatValue] > 0)?[NSString stringWithFormat:@"+%.2f",[self.model.amount floatValue]]:[NSString stringWithFormat:@"%.2f",[self.model.amount floatValue]];
    self.amountLabel.text = string;
    self.createTimeLabel.text = self.model.createDate;
    self.serialNumberLabel.text = self.model.orderNumber;
    self.amountTypeLabel.text = [self separatePaymentsAndWithfrawal:self.model.state];
    self.currentAmountLabel.text = [self.model.afteramount stringValue];
}


#pragma mark - 区分提现还是返佣
- (NSString *)separatePaymentsAndWithfrawal:(NSString *)state
{
    if ([state isEqualToString:@"0"]) {
        return @"返佣";
    }
    if ([state isEqualToString:@"1"]) {
        return @"提现";
    }
    return nil;
}



@end
