//
//  EmigratedFinishViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/12/8.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "EmigratedFinishViewController.h"

@interface EmigratedFinishViewController ()

@end

@implementation EmigratedFinishViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    switch (self.state) {
        case NotThrough:
        {
            NSString *string = [NSString stringWithFormat:@"您的得分为%@\n\n闯关失败!",self.score];
            NSMutableAttributedString *attributedString = [[NSMutableAttributedString alloc]initWithString:string];
            NSRange range = NSMakeRange(5, [self.score length]);
            [attributedString addAttribute:NSForegroundColorAttributeName value:[UIColor redColor] range:range];
            [attributedString addAttribute:NSFontAttributeName value:[UIFont fontWithName:@"HelveticaNeue-Bold" size:35] range:range];
            self.emigratedResultLabel.attributedText = attributedString;
        }
            break;
        case Through:
        {
            NSString *string = [NSString stringWithFormat:@"您的得分为%@\n\n恭喜您，闯关成功！",self.score];
            NSMutableAttributedString *attributedString = [[NSMutableAttributedString alloc]initWithString:string];
            NSRange range = NSMakeRange(5, [self.score length]);
            [attributedString addAttribute:NSForegroundColorAttributeName value:[UIColor redColor] range:range];
            [attributedString addAttribute:NSFontAttributeName value:[UIFont fontWithName:@"HelveticaNeue-Bold" size:35] range:range];
            self.integralLabel.text = [NSString stringWithFormat:@"+%@",self.integral];
            self.emigratedResultLabel.attributedText = attributedString;
        }
            break;
        case Audit:
        {
            self.emigratedResultLabel.text = @"您的回答已提交\n\n请等待反馈!";

        }
            break;
            
        default:
            break;
    }
}


#pragma mark - 完成
- (IBAction)finishButtonClickAction:(UIButton *)sender {
    
    if ([self.delegate respondsToSelector:@selector(finish)]) {
        [self.delegate finish];
    }
}


@end
