//
//  AnswerViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/12/7.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "AnswerViewController.h"
#import "AssessmentShortAnswerTableViewCell.h"
#import "AssessmentHeaderView.h"
#import "AssessmentTableViewCell.h"
#import "AssessmentShortAnswerTableViewCell.h"
#import "EmigratedFinishViewController.h"


@interface AnswerViewController ()<UITableViewDelegate,UITableViewDataSource,WYPopoverControllerDelegate,CompeteDelegate>


@property (nonatomic,strong) WYPopoverController *popover;

/**
 闯关详情
 */
@property (nonatomic,strong) TOPassLevelEntity *emigrated;

/**
 当前加载section
 */
@property (nonatomic,assign) NSInteger sectionPage;

@end

@implementation AnswerViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self getPassLevelDeltails];
}

#pragma mark - 查询题型
- (void)getPassLevelDeltails
{
    WS(weakSelf);
    [XBLoadingView showHUDViewWithDefault];
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:[NSString stringWithFormat:SERVERREQUESTURL(GETPASSLEVELDETAILS),self.passLevelId] WithRequestType:ONE WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        [XBLoadingView hideHUDViewWithDefault];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            weakSelf.emigrated = [[TOPassLevelEntity alloc] initWithDictionary:returnValue[@"data"] error:nil];
            [weakSelf.answerTableView reloadData];
        }else {
            [XBLoadingView showHUDViewWithText:returnValue[@"message"]];
        }
        
    } WithFailureBlock:^(NSError *error) {
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}

#pragma mark - <UITableViewDelegate,UITableViewDataSource>
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CustomTOPassLevelTopicEntity *entity = self.emigrated.topics[self.sectionPage];
    if ([entity.topicType isEqualToString:PASSLEVELTOPICTYPE_GAPFILLING] || [entity.topicType isEqualToString:PASSLEVELTOPICTYPE_SHORTANSWER]) {
        AssessmentShortAnswerTableViewCell *shortAnswerCell = [tableView dequeueReusableCellWithIdentifier:@"AssessmentShortAnswerTableViewCell" forIndexPath:indexPath];
        shortAnswerCell.entity = entity;
        return shortAnswerCell;
    }
    AssessmentTableViewCell *assessmentCell = [tableView dequeueReusableCellWithIdentifier:@"AssessmentTableViewCell" forIndexPath:indexPath];
    assessmentCell.emigratedEntity = entity.options[indexPath.row];
    return assessmentCell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    CustomTOPassLevelTopicEntity *entity = self.emigrated.topics[self.sectionPage];
    return entity.titleHeight;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CustomTOPassLevelTopicEntity *entity = self.emigrated.topics[self.sectionPage];
    if (entity.options.count) {
        CustomTOPassLevelTopicOptionEntity *answer = entity.options[indexPath.row];
        return answer.answerHeight;
    }
    return 200;
}

- (void)tableView:(UITableView *)tableView didEndDisplayingCell:(UITableViewCell *)cell forRowAtIndexPath:(NSIndexPath*)indexPath
{
    if ([cell isKindOfClass:[AssessmentShortAnswerTableViewCell class]]) {
        AssessmentShortAnswerTableViewCell *shortAnswerCell = (AssessmentShortAnswerTableViewCell *)cell;
        shortAnswerCell.shortAnswerTextView.text = nil;
    }
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return ONE;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    CustomTOPassLevelTopicEntity *entity = self.emigrated.topics[self.sectionPage];
    if ([entity.topicType isEqualToString:PASSLEVELTOPICTYPE_GAPFILLING] || [entity.topicType isEqualToString:PASSLEVELTOPICTYPE_SHORTANSWER]) {
        return ONE;
    }
    return entity.options.count;
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    AssessmentHeaderView *headerView = [tableView dequeueReusableCellWithIdentifier:@"AssessmentHeaderView"];
    headerView.emigratedEntity = self.emigrated.topics[self.sectionPage];
    return headerView.contentView;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    CustomTOPassLevelTopicEntity *entitys = self.emigrated.topics[self.sectionPage];
    if ([entitys.topicType isEqualToString:STUDYTOPICTYPE_SINGLE] || [entitys.topicType isEqualToString:STUDYTOPICTYPE_TRUEORFALSE]) {
        for (int i=0; i<entitys.options.count; i++) {
            CustomTOPassLevelTopicOptionEntity *entity = entitys.options[i];
            if (i == indexPath.row) {
                entity.isSelected = !entity.isSelected;
            }else {
                entity.isSelected = NO;
            }
        }
    }else if ([entitys.topicType isEqualToString:STUDYTOPICTYPE_MULTIPLE]) {
        CustomTOPassLevelTopicOptionEntity *answer = entitys.options[indexPath.row];
        answer.isSelected = !answer.isSelected;
    }
    [self.answerTableView reloadData];
}

#pragma mark - 下一步<最后一道题自动提交>
- (IBAction)nextButtonClickAction:(UIButton *)sender {

    if (self.sectionPage == self.emigrated.topics.count-1) {
        [self submitAnswer];
    }else {
        self.sectionPage += ONE;
        [self.answerTableView reloadData];
    }
}

#pragma mark - 提交答案
- (void)submitAnswer
{
    if ([self.delegate respondsToSelector:@selector(dismissController)]) {
        [self.delegate dismissController];
    }
    TOPassLevelResultEntity *studyResult = [[TOPassLevelResultEntity alloc]init];
    studyResult.passLevelId = self.passLevelId;
    studyResult.submitTime = [[self class] getTimeby:0];
    studyResult.employeeId = [Shoppersmanager manager].Shoppers.employee.fid;
    NSArray *answerArray = self.emigrated.topics;
    NSMutableArray *submitAnswerArray = [NSMutableArray array];
    //判断考核结果
    NSInteger allScore = 0;//总分
    studyResult.passResult = self.emigrated.passGrade > [studyResult.grade integerValue]?@"0":@"1";
    for (CustomTOPassLevelTopicEntity *topicEntity in answerArray) {
        
        TOPassLevelResultDetailEntity *resultEntity = [[TOPassLevelResultDetailEntity alloc] init];
        resultEntity.topicId = topicEntity.fid;
        //多选
        if ([topicEntity.topicType isEqualToString:STUDYTOPICTYPE_MULTIPLE]) {
            NSMutableString *answers = [[NSMutableString alloc] init];
            for (CustomTOPassLevelTopicOptionEntity *entity in topicEntity.options) {
                if (entity.isSelected == YES) {
                    [answers appendFormat:@"%@,",entity.value];
                }
            }
            resultEntity.answer = answers;
            //得分
            NSArray *answersArray = [topicEntity.answer componentsSeparatedByString:@","];
            NSInteger answerNumber = 0;
            for (NSString *answer in answersArray) {
                for (CustomTOStudyTopicOptionEntity *entity in topicEntity.options) {
                    if ([answer isEqualToString:entity.value] && entity.isSelected) {
                        answerNumber += 1;
                    }
                }
            }
            if (answerNumber == answersArray.count) {
                resultEntity.grade = topicEntity.grade;
                allScore += [topicEntity.grade integerValue];
            }
        }
        //判断
        if ([topicEntity.topicType isEqualToString:STUDYTOPICTYPE_TRUEORFALSE]) {
            for (CustomTOPassLevelTopicOptionEntity *entity in topicEntity.options) {
                if (entity.isSelected == YES) {
                    resultEntity.answer = entity.name;
                    if ([topicEntity.answer isEqualToString:entity.name]) {
                        resultEntity.grade = topicEntity.grade;
                        allScore += [topicEntity.grade integerValue];
                    }
                }
            }
        }
        //单选
        if ([topicEntity.topicType isEqualToString:STUDYTOPICTYPE_SINGLE]) {
            for (CustomTOPassLevelTopicOptionEntity *entity in topicEntity.options) {
                if (entity.isSelected == YES) {
                    resultEntity.answer = entity.value;
                    if ([topicEntity.answer isEqualToString:entity.value]) {
                        resultEntity.grade = topicEntity.grade;
                        allScore += [topicEntity.grade integerValue];
                    }
                }
            }
        }
        //填空、简答
        if ([topicEntity.topicType isEqualToString:PASSLEVELTOPICTYPE_GAPFILLING] || [topicEntity.topicType isEqualToString:PASSLEVELTOPICTYPE_SHORTANSWER]) {
                resultEntity.answer = topicEntity.answer;
                studyResult.passResult = @"2";//人工审核
        }
        [submitAnswerArray addObject:resultEntity];
    }
    studyResult.details = (NSArray<TOPassLevelResultDetailEntity>*)submitAnswerArray;
    studyResult.grade = [NSNumber numberWithFloat:allScore];
    
    [XBLoadingView showHUDViewWithDefault];
    WS(weakSelf);
    NSLog(@"%@",[studyResult toDictionary]);
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(SUBMITEMIGRATEDANSWER) WithRequestType:ZERO WithParameter:studyResult WithReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            [weakSelf determineIsQualified:[studyResult.grade integerValue] passResult:[studyResult.passResult integerValue]];
        }else{
            [XBLoadingView showHUDViewWithText:returnValue[@"message"]];
        }
        
    } WithFailureBlock:^(NSError *error) {
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}

#pragma mark - 判断得分是否及格
- (void)determineIsQualified:(NSInteger)allScore passResult:(NSInteger)state
{
    EmigratedFinishViewController *finish = [[[self class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"EmigratedFinishViewController"];
    finish.delegate = self;
    finish.preferredContentSize = CGSizeMake(520, 400);
    if (self.emigrated.passGrade > allScore) {
        finish.state = state;
        finish.score = [NSString stringWithFormat:@"%ld",allScore];
        [self showPopoverView:finish];
        
    }else {
    
        WS(weakSelf);
        [XBLoadingView showHUDViewWithDefault];
        NSString *url = [NSString stringWithFormat:SERVERREQUESTURL(GETINTEGRAL),@"passLevelScore"];
        [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:url WithRequestType:ONE WithParameter:nil WithReturnValueBlock:^(id returnValue) {
            [XBLoadingView hideHUDViewWithDefault];
            if ([returnValue[@"code"] isEqualToNumber:@0]) {
                finish.state = state;
                finish.score = [NSString stringWithFormat:@"%ld",allScore];
                finish.integral = [NSString stringWithFormat:@"+%@",returnValue[@"data"][@"optionValue"]];
                [weakSelf showPopoverView:finish];
                
            }else {
                [XBLoadingView showHUDViewWithText:returnValue[@"message"]];
            }
            
        } WithFailureBlock:^(NSError *error) {
            [XBLoadingView showHUDViewWithText:error.localizedDescription];
        }];
    }
}

#pragma mark - 完成
- (void)finish
{
    [self.popover dismissPopoverAnimated:YES];
}

#pragma mark - 弹出框
- (void)showPopoverView:(BaseViewController *)controller
{
    self.popover = [[WYPopoverController alloc] initWithContentViewController:controller];
    self.popover.theme.fillBottomColor = [UIColor clearColor];
    self.popover.theme.fillTopColor = [UIColor clearColor];
    self.popover.theme.glossShadowColor = [UIColor clearColor];
    self.popover.delegate = self;
    [self.popover presentPopoverAsDialogAnimated:YES options:WYPopoverAnimationOptionFadeWithScale];
}

#pragma mark - 点击空白禁止收起
- (BOOL)popoverControllerShouldDismissPopover:(WYPopoverController *)popoverController
{
    return NO;
}





@end
