//
//  VideoHelperViewController.h
//  Lighting
//
//  Created by 曹云霄 on 2016/11/25.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "BaseViewController.h"
#import <AVFoundation/AVFoundation.h>
#import "VIMediaCache.h"

@protocol VideoPlayerDelegate <NSObject>

@optional
- (void)videoPlayFinish:(CustomStudyEntity *)studyEntity;

@end

@interface VideoHelperViewController : BaseViewController


/**
 播放Layer
 */
@property (nonatomic,strong) AVPlayerLayer *playerLayer;
@property (nonatomic,strong) AVPlayer *customPlayer;
@property (nonatomic,strong) AVPlayerItem *playerItem;
@property (nonatomic,strong) id avplayerServer;
@property (nonatomic,strong) VIResourceLoaderManager *resourceLoaderManager;
@property (nonatomic,weak) id<VideoPlayerDelegate> delegate;

/**
 视频导航栏
 */
@property (weak, nonatomic) IBOutlet UIView *videoNavigationView;

/**
 视频title
 */
@property (weak, nonatomic) IBOutlet UILabel *videoTitleLabel;

/**
 视频工具类
 */
@property (weak, nonatomic) IBOutlet UIView *videoToolView;

/**
 播放按钮
 */
@property (weak, nonatomic) IBOutlet UIButton *playButton;

/**
 播放进度
 */
@property (weak, nonatomic) IBOutlet UIProgressView *bufferProgressView;

/**
 当前播放时间
 */
@property (weak, nonatomic) IBOutlet UILabel *playingTimeLabel;

/**
 总时间
 */
@property (weak, nonatomic) IBOutlet UILabel *playItemTotalTimeLabel;

/**
 播放路径
 */
@property (nonatomic,copy) CustomStudyEntity *learningItem;

/**
 放大缩小        boolValue(true 全屏)
 */
@property (nonatomic,copy) void(^zoomButtonClickBlock)(BOOL boolValue);

/**
 重置播放器
 */
- (void)resetPlayer;


@end
