//
//  CustomStudyEntity.m
//  Lighting
//
//  Created by 曹云霄 on 2016/12/5.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CustomStudyEntity.h"

@implementation CustomStudyEntity


- (CGFloat)contentHeight
{
    if (!_contentHeight) {
        _contentHeight = [self calculateStudyIntroductionHeight:self.content]+78;
    }
    return _contentHeight;
}

- (CGFloat)teacherIntroHeight
{
    if (!_teacherIntroHeight) {
        _teacherIntroHeight = [self calculateStudyIntroductionHeight:self.teacherIntro]+108;
    }
    return _teacherIntroHeight;
}


#pragma mark - 计算高度
- (CGFloat)calculateStudyIntroductionHeight:(NSString *)content
{
    CGSize s = [content boundingRectWithSize:CGSizeMake(ScreenWidth*2/3-28*2, CGFLOAT_MAX) options:NSStringDrawingUsesLineFragmentOrigin | NSStringDrawingUsesFontLeading attributes:@{NSFontAttributeName:[UIFont systemFontOfSize:13]} context:nil].size;
    return s.height;
}



@end
