//
//  GuideIntegralViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/16.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "GuideIntegralViewController.h"
#import "IntegralDetailsViewController.h"
#import "PrizeMainViewController.h"

@interface GuideIntegralViewController ()

@end

@implementation GuideIntegralViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self addChildViewController];
}

#pragma mark - 积分赋值
- (void)integralAssignment:(RsScoreDetails *)scoreModel
{
    self.currentIntegralLabel.text = [NSString stringWithFormat:@"%.0lf",scoreModel.currentScore];
    self.quarterIntegralLabel.text = [NSString stringWithFormat:@"%ld",scoreModel.quarterlyRanking];
    self.yearIntegralLabel.text = [NSString stringWithFormat:@"%ld",scoreModel.annualRanking];
}

#pragma mark - 添加积分明细、导购头像
- (void)addChildViewController
{
    IntegralDetailsViewController *integralDetails = [[[self class] getGuideIntegralStoryboardClass] instantiateViewControllerWithIdentifier:@"IntegralDetailsViewController"];
    integralDetails.cellType = IntrgralTableView;
    [self addChildViewController:integralDetails];
    integralDetails.view.frame = CGRectMake(0, 50, self.integralDetailsView.mj_w, self.integralDetailsView.mj_h-50);
    [self.integralDetailsView addSubview:integralDetails.view];
    NSString *headerurl = [Shoppersmanager manager].Shoppers.employee.picture;
    [self.guideHeaderView sd_setImageWithURL:[NSURL URLWithString:headerurl] placeholderImage:ReplaceImage];
    WS(weakSelf);
    [integralDetails setReturnIntegralDetailsBlock:^(RsScoreDetails *model) {
        [weakSelf integralAssignment:model];
    }];
}

#pragma mark - 礼品兑换
- (IBAction)exchangeButtonClick:(UIButton *)sender {
    
    PrizeMainViewController *prizeMainVC = [[[self class] getGuideIntegralStoryboardClass] instantiateViewControllerWithIdentifier:@"PrizeMainViewController"];
    [self.navigationController pushViewController:prizeMainVC animated:YES];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}


@end
