//
//  CustomBorderLabel.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/23.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CustomBorderLabel.h"

@implementation CustomBorderLabel


- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        self.font = [UIFont systemFontOfSize:12];
    }
    return self;
}

- (void)setCustomText:(NSString *)customText
{
    _customText = customText;
    UIColor *color;
    if ([customText isEqualToString:@"行业动态"]) {
        color = RGB(133, 210, 107, 1);
    }else if ([customText isEqualToString:@"品牌资讯"]) {
        color = RGB(0, 127, 210, 1);
    }else if ([customText isEqualToString:@"活动公告"]) {
        color = RGB(241, 171, 0, 1);
    }
    self.layer.masksToBounds = YES;
    self.layer.borderWidth = 1.0f;
    self.layer.borderColor = color.CGColor;
    self.layer.cornerRadius = 2.0f;
    self.textColor = color;
    self.text = _customText;
}
@end
