//
//  AnnountcementDetailViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/23.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "AnnountcementDetailViewController.h"
#import "WkWebViewViewController.h"
#import "AnnouncementContentTableViewCell.h"
#import "AnnouncementListTableViewCell.h"
#import "CustomWKWebViewController.h"

@interface AnnountcementDetailViewController ()<UITableViewDelegate,UITableViewDataSource>


/**
 公告标题
 */
@property (weak, nonatomic) IBOutlet UILabel *annountcementTitleLabel;

/**
 公告headerView
 */
@property (weak, nonatomic) IBOutlet UIView *announcementHeaderView;

/**
 公告类型
 */
@property (weak, nonatomic) IBOutlet CustomBorderLabel *annountcementTypeLabel;

/**
 公告时间
 */
@property (weak, nonatomic) IBOutlet UILabel *annountcementTimeLabel;

/**
 公告阅读数
 */
@property (weak, nonatomic) IBOutlet UILabel *annountcementReadCountLabel;

/**
 公告内容高度
 */
@property (nonatomic,assign) CGFloat annountcementContentHeigt;

/**
 公告数据源
 */
@property (nonatomic,strong) TOAfficheEntity *afficheResult;



@end

@implementation AnnountcementDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpTableViewAction];
    [self addChildWebViewController];
    [self getAnnouncementDetailsDatasAction];
}

#pragma mark - 设置Tableview
- (void)setUpTableViewAction
{
    self.announcementDetailsTableView.tableFooterView = [UIView new];
    [self.announcementDetailsTableView registerClass:[AnnouncementContentTableViewCell class] forCellReuseIdentifier:@"AnnouncementContentTableViewCell"];
    self.announcementDetailsTableView.tableHeaderView = self.announcementHeaderView;
}

#pragma mark - 设置HeaderView
- (void)setUpTableViewHeaderView:(TOAfficheEntity *)entity
{
    self.annountcementTitleLabel.text = entity.title;
    self.annountcementTimeLabel.text = entity.createDate;
    self.annountcementTypeLabel.customText = entity.afficheType;
    self.annountcementReadCountLabel.text = [NSString stringWithFormat:@"%ld",entity.attachmentUrls.count];
}

#pragma mark - WKWebView
- (void)addChildWebViewController
{
    WS(weakSelf);
    WkWebViewViewController *webView = [[WkWebViewViewController alloc]initWithReturnContentSize:^(CGFloat contentHeight) {
        weakSelf.annountcementContentHeigt = contentHeight;
        webView.view.frame = CGRectMake(0, 0, ScreenWidth, contentHeight);
        [weakSelf.announcementDetailsTableView reloadData];
    }];
    self.annountcementContentHeigt = 44;//默认值
    webView.view.frame = CGRectMake(0, 0, ScreenWidth, self.annountcementContentHeigt);
    [self addChildViewController:webView];
}

#pragma mark - 获取公告详情数据
- (void)getAnnouncementDetailsDatasAction
{
    WS(weakSelf);
    [XBLoadingView showHUDViewWithDefault];;
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:[NSString stringWithFormat:SERVERREQUESTURL(AFFICHEdETAILS),self.announcementID] WithRequestType:ONE WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            weakSelf.afficheResult = [[TOAfficheEntity alloc]initWithDictionary:returnValue[@"data"] error:nil];
            WkWebViewViewController *webView = [weakSelf.childViewControllers firstObject];
            webView.htmlString = weakSelf.afficheResult.content;
            [weakSelf setUpTableViewHeaderView:weakSelf.afficheResult];
        }else {
            [XBLoadingView showHUDViewWithText:returnValue[@"message"]];
        }
        [weakSelf.announcementDetailsTableView reloadData];
        
    } WithFailureBlock:^(NSError *error) {
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}

#pragma mark - <UITableViewDelegate,UITableViewDataSource>
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 0) {
        AnnouncementContentTableViewCell *contentCell = [tableView dequeueReusableCellWithIdentifier:@"AnnouncementContentTableViewCell" forIndexPath:indexPath];
        [contentCell.contentView addSubview:self.childViewControllers[0].view];
        return contentCell;
    }
    AnnouncementListTableViewCell *listCell = [tableView dequeueReusableCellWithIdentifier:@"AnnouncementListTableViewCell" forIndexPath:indexPath];
    listCell.attachmentEntity = self.afficheResult.attachmentUrls[indexPath.row-1];
    return listCell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    
    return self.afficheResult.attachmentUrls.count+1;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 0) {
        return self.annountcementContentHeigt;
    }
    return 80;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    CustomWKWebViewController *wkWebView = [[CustomWKWebViewController alloc]init];
    TOAttachmentEntity *attachment = self.afficheResult.attachmentUrls[indexPath.row-1];
    wkWebView.urlString = attachment.fileUrl;
    [self presentViewController:wkWebView animated:YES completion:nil];
}

@end
