//
//  ProductScreeningCollectionViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 16/6/2.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ProductScreeningCollectionViewCell.h"

@implementation ProductScreeningCollectionViewCell

- (void)setModel:(TOGoodsEntityModel *)model
{
    _model = model;
    NSArray *images = [_model.pictures componentsSeparatedByString:@","];
    [self.goodsImageView sd_setImageWithURL:[NSURL URLWithString:[images firstObject]] placeholderImage:REPLACEIMAGE];
    self.goodsName.text = _model.name;
    self.goodsSpecifications.text = _model.code;
    self.goodsPrice.text = [NSString stringWithFormat:@"￥%@",[_model.tagPrice stringValue]];
    if (model.isSelectedState) {
        self.layer.borderWidth = 2.0f;
        self.layer.borderColor = kMainBlueColor.CGColor;
    }else
    {
        self.layer.borderWidth = 0.f;
    }
}

@end
