//
//  SearchViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/16.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "SearchViewController.h"
#import "SearchCollectionViewCell.h"
#import "HotCollectionViewCell.h"
#import "ProductLibraryViewController.h"


@interface SearchViewController ()<UICollectionViewDelegate,UICollectionViewDataSource>

/**
 * 数据源
 */
@property (nonatomic,strong) HotFilter *response;

/**
 *  本地搜索历史
 */
@property (nonatomic,strong) NSMutableArray *localSearchArray;

@end

@implementation SearchViewController



/**
 *  本地搜索历史初始化
 */
- (NSMutableArray *)localSearchArray
{
    if (_localSearchArray == nil) {
        
        _localSearchArray = [NSMutableArray array];
    }
    return _localSearchArray;
}


- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    [self uiConfigAction];
    [self getHotSearchdatas];
}


#pragma mark -布局
- (void)uiConfigAction
{
    self.hotCollectionviewLayout.itemSize = CGSizeMake(120, 44);
    self.hotCollectionviewLayout.minimumLineSpacing = 10;
    self.hotCollectionviewLayout.minimumInteritemSpacing = 10;
    self.hotCollectionviewLayout.sectionInset = UIEdgeInsetsMake(10, 10, 10, 10);
    
    self.historyLayout.itemSize = CGSizeMake(120, 44);
    self.historyLayout.minimumLineSpacing = 10;
    self.historyLayout.minimumInteritemSpacing = 10;
    self.historyLayout.sectionInset = UIEdgeInsetsMake(10, 10, 10, 10);
    
    self.historyCollectionView.delegate = self;
    self.historyCollectionView.dataSource = self;
    self.hotCollectionView.dataSource = self;
    self.hotCollectionView.delegate = self;
    self.hotCollectionView.alwaysBounceVertical = YES;
    self.historyCollectionView.alwaysBounceVertical = YES;

    //保存输入内容
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(searchInputString:) name:SEARCHSTRING object:nil];
}


#pragma mark -输入内容
- (void)searchInputString:(NSNotification *)not
{
    [self.localSearchArray addObject:not.object];
    //调用商品控制器
    ProductLibraryViewController *productVC = [[self getStoryboardWithName] instantiateViewControllerWithIdentifier:@"productlibrary"];
    productVC.selectedCode = not.object;
    [self.navigationController pushViewController:productVC animated:YES];
}


#pragma mark -获取本地存储搜索历史
- (void)getlocalsaveDatas
{
    NSString *homeDictionary = [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES) objectAtIndex: 0];
    NSString *homepath = [homeDictionary stringByAppendingPathComponent:SEARCHHISTORY];//添加储存的文件名
    self.localSearchArray = [NSKeyedUnarchiver unarchiveObjectWithFile:homepath];
    [self.historyCollectionView reloadData];
}



#pragma mark -归档搜索历史
- (void)SaveSearchDatas
{
    NSString *homeDictionary = [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES) objectAtIndex: 0];
    NSString *homepath = [homeDictionary stringByAppendingPathComponent:SEARCHHISTORY];//添加储存的文件名
    BOOL flag = [NSKeyedArchiver archiveRootObject:self.localSearchArray toFile:homepath];//归档一个字符串
    if (flag) {
        NSLog(@"归档成功");
    }
}


#pragma mark -将要加载前获取本地搜索历史
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    [self getlocalsaveDatas];
}


#pragma mark -视图消失后归档搜索历史
- (void)viewDidDisappear:(BOOL)animated
{
    [super viewDidDisappear:animated];
    [self.view endEditing:YES];
    [self SaveSearchDatas];
}




#pragma mark -获取热门搜索数据
- (void)getHotSearchdatas
{
    [self CreateMBProgressHUDLoding];
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:[NSString stringWithFormat:@"%@%@",ServerAddress,@"/hottag/getHotTag"] WithRequestType:1 WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        [self RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            
             self.response = [[HotFilter alloc]initWithDictionary:returnValue[@"data"] error:nil];
            [self.hotCollectionView reloadData];
            
        }else
        {
            [self ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        
    } WithFailureBlock:^(id error) {
        [self RemoveMBProgressHUDLoding];
    }];
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    if ([collectionView isEqual:self.historyCollectionView]) {
        
         SearchCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"firstcell" forIndexPath:indexPath];
        cell.searchLabe.text = [self.localSearchArray objectAtIndex_opple:indexPath.item];
        return cell;
    }
    if ([collectionView isEqual:self.hotCollectionView]) {
        
        HotCollectionViewCell  *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"secondcell" forIndexPath:indexPath];
        cell.responseDatas = [self.response.list objectAtIndex_opple:indexPath.item];
        return cell;
    }
    
    return nil;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    
    if ([collectionView isEqual:self.hotCollectionView]) {
        
        return self.response.list.count;
    }
    
    return self.localSearchArray.count;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    if ([collectionView isEqual:self.hotCollectionView]) {
        
        [self.localSearchArray addObject:[[self.response.list objectAtIndex_opple:indexPath.item] typename]];
        //调用商品控制器
        ProductLibraryViewController *productVC = [[self getStoryboardWithName] instantiateViewControllerWithIdentifier:@"productlibrary"];
        productVC.selectedCode = [[self.response.list objectAtIndex_opple:indexPath.item] typecode];
        [self.navigationController pushViewController:productVC animated:NO];
    }
    else if ([collectionView isEqual:self.historyCollectionView])
    {
        //调用商品控制器
        ProductLibraryViewController *productVC = [[self getStoryboardWithName] instantiateViewControllerWithIdentifier:@"productlibrary"];
        productVC.selectedCode = [self.localSearchArray objectAtIndex_opple:indexPath.item];
        [self.navigationController pushViewController:productVC animated:NO];
    }
}



#pragma mark -释放
- (void)dealloc
{
    [[NSNotificationCenter defaultCenter]removeObserver:self];
}



#pragma mark -清除搜索历史
- (IBAction)delecteSearchHistoryButtonClick:(UIButton *)sender {
    
    
    NSString *homeDictionary = [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES) objectAtIndex: 0];
    NSString *homepath = [homeDictionary stringByAppendingPathComponent:SEARCHHISTORY];//添加储存的文件名
    NSFileManager *manager = [NSFileManager defaultManager];
    [manager removeItemAtPath:homepath error:nil];
    
    [self.localSearchArray removeAllObjects];
    [self.historyCollectionView reloadData];
    
}




- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
