//
//  RightSubView.m
//  Lighting
//
//  Created by mac on 16/5/10.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "RightSubView.h"

@implementation RightSubView
- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
         
        [self initdata];
        [self initSubView];
    }
    return self;
}
-(void)initdata
{
//    NSString *imageName = [NSString stringWithFormat:@"05产品库-详情_03" ];
//   UIImage *image= [UIImage imageNamed:imageName];
    self.dataArray=[[NSMutableArray alloc]init];
    self.productModelArray=[[NSMutableArray alloc]init];
    
//    待接收
}
-(void)initSubView
{
    self.selectBtn=[UIButton buttonWithType:UIButtonTypeCustom];
    self.selectBtn.frame=CGRectMake(self.frame.size.width-100, self.frame.size.height-60, 60, 60);
    self.selectBtn.tag=300;
    [self.selectBtn setBackgroundImage:[UIImage imageNamed:@"产品2"] forState:UIControlStateNormal];
    [self.selectBtn addTarget:self action:@selector(rightBtnDidSelected:) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:self.selectBtn];
    self.scrollView=[[UIScrollView alloc]initWithFrame:CGRectMake(0, 0, self.frame.size.width, self.frame.size.height-100)];
       // 禁用滚动条，只设置水平方向的滚动条即可，竖直方向的滚动范围是0，所以没必要设置
    self.scrollView.showsVerticalScrollIndicator = NO;
    [self addSubview:self.scrollView];
    [self showProductPicture];
}
-(void)showProductPicture
{
    [self.scrollView.subviews makeObjectsPerformSelector:@selector(removeFromSuperview)];
    // contentSize的y值为0表示在垂直方向上不做滚动
    self.scrollView.contentSize = CGSizeMake(0, (self.dataArray.count+1) * (100+10));
    for (int i=0; i<self.dataArray.count; i++) {
        
        UIButton *button=[[UIButton alloc]initWithFrame:CGRectMake(80, 20+i*(100+10), 100, 75)];
        UIImage *image=[self.dataArray objectAtIndex:i];
        [button setImage:image forState:UIControlStateNormal];
        button.tag=100+i;
        [button addTarget:self action:@selector(clicked:) forControlEvents:UIControlEventTouchUpInside];
        UILongPressGestureRecognizer *longPressGR =
        [[UILongPressGestureRecognizer alloc] initWithTarget:self action:@selector(longPress:)];
      
        longPressGR.minimumPressDuration = 0.5;
        [button addGestureRecognizer:longPressGR];
        
        [self.scrollView addSubview:button];
        
    }

}
//单次点击
-(void)clicked:(UIButton*)sender
{
    NSLog(@"%ld",(long)(sender.tag));
    if ([self.delegate respondsToSelector:@selector(resetSubProductImage:productModel:)]) {
        
        [self.delegate resetSubProductImage:sender.imageView.image productModel:[self.productModelArray objectAtIndex:sender.tag-100]];
    }
    
    //    resetSuperBackGroundImage
}
//长按
-(void)longPress:(id)sender
{
    UILongPressGestureRecognizer *longPress=sender;
    if (longPress.state == UIGestureRecognizerStateBegan) {
        NSInteger index=longPress.view.tag-100;
        if (self.dataArray.count>index) {
            [self.dataArray removeObjectAtIndex:index];
            [self.productModelArray removeObjectAtIndex:index];
            [self showProductPicture];
        }
        
    }
    else {
        
    }
     NSLog(@"长按");
}

-(void)rightBtnDidSelected:(UIButton *)sender
{
    if ([self.delegate respondsToSelector:@selector(buttonClick:withButton:)]) {
        
        [self.delegate buttonClick:sender.tag withButton:sender];
    }

}
-(void)addRightSubViewImage:(UIImage*)image productModel:(TOGoodsEntity *)productModel
{
    [self.productModelArray addObject:productModel];
    [self.dataArray addObject:image];
    [self showProductPicture];
    
}
/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
