//
//  GoodsImageView.m
//  Lighting
//
//  Created by 曹云霄 on 16/6/3.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "GoodsImageView.h"

@implementation GoodsImageView

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        UIRotationGestureRecognizer *rotationGes = [[UIRotationGestureRecognizer alloc] initWithTarget:self action:@selector(backGroundViewRotationAction:)];
        rotationGes.delegate = self;
        [self addGestureRecognizer:rotationGes];
        
        UIPinchGestureRecognizer *pinchGes = [[UIPinchGestureRecognizer alloc] initWithTarget:self action:@selector(backGroundViewPinchAction:)];
        pinchGes.delegate =self;
        [self addGestureRecognizer:pinchGes];
        
        UIPanGestureRecognizer *panGes = [[UIPanGestureRecognizer alloc] initWithTarget:self action:@selector(backGroundViewPanAction:)];
        [panGes setMinimumNumberOfTouches:1];
        [panGes setMaximumNumberOfTouches:1];
        panGes.delegate = self;
        [self addGestureRecognizer:panGes];
        
        UILongPressGestureRecognizer *longGes = [[UILongPressGestureRecognizer alloc]initWithTarget:self action:@selector(LongPressAction:)];
        longGes.delegate = self;
        [self addGestureRecognizer:longGes];
    }
    return self;
}



#pragma mark -缩放
-(void)backGroundViewPinchAction:(UIPinchGestureRecognizer *)gesture{
    
    UIView *view = self;
    if (gesture.state == UIGestureRecognizerStateBegan || gesture.state == UIGestureRecognizerStateChanged) {
        view.transform = CGAffineTransformScale(view.transform, gesture.scale, gesture.scale);
        gesture.scale = 1;
    }
}

#pragma mark -拖拉
-(void)backGroundViewPanAction:(UIPanGestureRecognizer *)gesture{
    
    UIView *view = gesture.view;
    if (gesture.state == UIGestureRecognizerStateBegan || gesture.state == UIGestureRecognizerStateChanged) {
        CGPoint translation = [gesture translationInView:view.superview];
        [view setCenter:(CGPoint){view.center.x + translation.x, view.center.y + translation.y}];
        [gesture setTranslation:CGPointZero inView:view.superview];
    }
}


#pragma mark -旋转
-(void)backGroundViewRotationAction:(UIRotationGestureRecognizer *)gesture{
    
    self.transform = CGAffineTransformRotate(self.transform, gesture.rotation);
    gesture.rotation = 0;
}

#pragma mark -长按
- (void)LongPressAction:(UILongPressGestureRecognizer *)longPress
{
    if (longPress.state == UIGestureRecognizerStateBegan) {
        if (self.delectedBlock) {
            self.delectedBlock(self.model);
        }
        [self removeFromSuperview];
    }
}


@end
