//
//  PopoverViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/9.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "PopoverViewController.h"

@interface PopoverViewController ()<UITableViewDelegate,UITableViewDataSource>

@property (nonatomic,strong) UITableView *popoverTableView;

@end

@implementation PopoverViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
}


#pragma mark -UI
- (void)uiConfigAction
{
    self.popoverTableView = [[UITableView alloc]initWithFrame:CGRectMake(0, 0, self.contentSize.width, self.contentSize.height) style:UITableViewStylePlain];
    self.popoverTableView.dataSource = self;
    self.popoverTableView.delegate = self;
    self.popoverTableView.showsVerticalScrollIndicator = NO;
    self.popoverTableView.tableFooterView = [UIView new];
    [self.view addSubview:self.popoverTableView];
//    self.popoverTableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self.popoverTableView registerClass:[UITableViewCell class] forCellReuseIdentifier:@"popovercell"];
}


#pragma mark -填充数据
- (void)setDatasArray:(NSArray *)datasArray
{
    _datasArray = datasArray;
    [self.popoverTableView reloadData];
}


#pragma mark - UITableViewDataSource
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"popovercell" forIndexPath:indexPath];
    
    //显示纯图片
    if (self.isPictures) {
        cell.imageView.image = TCImage([self.datasArray objectAtIndex_opple:indexPath.row]);
        return cell;
    }
    if (self.isString) {
        cell.textLabel.text = [self.datasArray objectAtIndex_opple:indexPath.row];
    }else
    {
       cell.textLabel.text = [[self.datasArray objectAtIndex_opple:indexPath.row] typeName];
    }
    cell.textLabel.textAlignment = NSTextAlignmentCenter;
    cell.textLabel.font = [UIFont systemFontOfSize:14];
    return cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.datasArray.count;
}


- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    if (self.isPictures)
    {
        if ([self.delegate respondsToSelector:@selector(returnWithIndexSelected:)]) {
            
            
            [self.delegate returnWithIndexSelected:indexPath.row];
        }
    }else
    {
        if ([self.delegate respondsToSelector:@selector(returnCellindexpathwithrow:WithcellTitle:Withselected:)]) {
            
            
            //判断是为纯字符串选中
            if (self.isString) {
                [self.delegate returnCellindexpathwithrow:[self.datasArray objectAtIndex_opple:indexPath.row] WithcellTitle:[self.datasArray objectAtIndex_opple:indexPath.row] Withselected:_Selectedindex];
                
            }else
                
            {
              [self.delegate returnCellindexpathwithrow:[[self.datasArray objectAtIndex_opple:indexPath.row] typecode] WithcellTitle:[[self.datasArray objectAtIndex_opple:indexPath.row] typeName] Withselected:_Selectedindex];
            }
        }
    }    
}


- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 44;
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


@end
