//
//  BaseViewController.h
//  Lighting
//
//  Created by 曹云霄 on 16/4/27.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>

@interface BaseViewController : UIViewController




/**
 *  结束刷新
 *
 *  @param TableView Tableview
 */
- (void)endRefreshingForTableView:(UIScrollView *)TableView;


/**
 *  MBProgressHUD等待视图
 */
- (void)CreateMBProgressHUDLoding;

/**
 *  移除MBProgressHUD等待视图
 */
- (void)RemoveMBProgressHUDLoding;

/**
 *  渐隐提示框待回调Block
 */
- (void)SHOWPrompttext:(NSString *)Text ComcpleteBlock:(void(^)())completed;

/**
 *  获得主体的storyboard对象
 */
+ (UIStoryboard *)getMainStoryboardClass;

/**
 获得公告storyboard对象
 */
+ (UIStoryboard *)getAnnouncementStoryboardClass;

/**
 获得学习中心storyboard对象
 */
+ (UIStoryboard *)getLearningCenterStoryboardClass;

/**
 获得积分storyboard对象
 */
+ (UIStoryboard *)getGuideIntegralStoryboardClass;

/**
 *  调用打印机
 */
- (void)callAirprintWithdata:(NSString *)PDFpath SuccessBlock:(void(^)())success ErrorBlock:(void(^)())failed;



/**
 *  成功等待视图
 */
- (void)SuccessMBProgressView:(NSString *)successString;

/**
 *  提示信息等待视图
 */
- (void)ErrorMBProgressView:(NSString *)errorString;


/**
 *  纯文本提示框
 */
- (void)SHOWPrompttext:(NSString *)Text;

/**
 *  显示提示图片、文本
 */
- (void)PromptinformationViewWithimage:(UIImage *)image withTitle:(NSString *)title withpoint:(CGPoint)point;

/**
 *  删除提示图片、文本
 */
- (void)RemovePromptinformationView;

/**
 *  提示框
 *
 */
- (void)promptCustomerTitle:(NSString *)title finish:(void(^)())complete;


/**
 *  查询订单状态图片
 */
+ (UIImage *)ReturnOrderStateImageWithStateCode:(NSInteger)ordercode;

/**
 *  查询订单状态文本      //code == 0 取文字  code == 1取颜色
 */
+ (id)ReturnOrderStateTitleWithStateCode:(NSInteger)ordercode withPoint:(CGPoint)point WithCode:(NSInteger)code;


/**
 *  查询购物车数量
 */
- (void)QueryShoppingCarNumber;

/**
 *  查询购物车商品
 */
- (void)queryShoppingCarGoods;


/**
 *  系统提示框
 */
- (void)promptCustomerWithString:(NSString *)message;


/**
 *  进度条
 */
- (void)ShowProgressView:(double)progress;


/**
 *  提示框
 */
@property (nonatomic,strong) MBProgressHUD*TCHud;

/**
 *  友好化时间
 */
+ (NSString *) compareCurrentTime:(NSString *)str;

/**
 *  获取版本号
 */
- (NSString*)getAppVersion;

/**
 *  通过面额获取相应的图片
 */
+ (UIImage *)getCorrespondingPictures:(NSInteger)total;

/**
 *  判断字符串是否为空
 */
+ (BOOL)isBlankString:(NSString *)string;


@end
