//
//  screeningSecondView.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/8.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "screeningSecondView.h"
#import "ScreeningFirstCollectionViewCell.h"

#define WIDTH self.screeningCollectionView.frame.size.width

@implementation screeningSecondView

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/




- (void)awakeFromNib
{
    [self uiConfigAction];
}



#pragma mark - 布局
- (void)uiConfigAction
{
    self.screeningTableview.delegate = self;
    self.screeningTableview.dataSource = self;
    self.screeningTableview.backgroundColor = [UIColor lightGrayColor];
    [self.screeningTableview registerClass:[UITableViewCell class] forCellReuseIdentifier:@"tableviewcell"];
    
    self.screeningLayout.itemSize = CGSizeMake((WIDTH-127)/3, 35);
    self.screeningLayout.minimumLineSpacing = 30;
    self.screeningLayout.minimumInteritemSpacing = 10;
    self.screeningLayout.sectionInset = UIEdgeInsetsMake(20, 30, 20, 30);
    [self.screeningCollectionView registerClass:[ScreeningFirstCollectionViewCell class] forCellWithReuseIdentifier:@"cell"];
    self.screeningCollectionView.dataSource = self;
    self.screeningCollectionView.delegate = self;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"tableviewcell" forIndexPath:indexPath];
    cell.textLabel.text = @"全部";
    cell.backgroundColor = [UIColor clearColor];
    cell.textLabel.textAlignment = NSTextAlignmentCenter;
    return cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 5;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 70;
}


- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    ScreeningFirstCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"cell" forIndexPath:indexPath];
    cell.titleLabe.text = @"壁灯";
    return cell;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return 20;
}



























@end
