//
//  GenerateOrdersViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/5.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "GenerateOrdersViewController.h"
#import "GenerateOrdersTableViewCell.h"
#import "GenerateOrdersModifyTableViewCell.h"
#import "PersonInformationTableViewCell.h"
#import "CommodityListTableViewCell.h"
#import "AllpriceTableViewCell.h"
#import "AddaddressViewController.h"
#import "ModifyShippingAddressView.h"
#import "AppDelegate.h"
#import "OrderdetailsViewController.h"

@interface GenerateOrdersViewController ()<UITableViewDelegate,UITableViewDataSource>

/**
 *  增加或者修改地址
 */
@property (nonatomic,strong) ModifyShippingAddressView *addressView;

/**
 *  城市选择器
 */
@property (nonatomic,strong)ModifyShippingAddressView *citySelecteview;

@property (nonatomic,strong) UIView *Tabbarview;
@end

@implementation GenerateOrdersViewController


/**
 *  城市选择View
 *
 *  @return ModifyShippingAddressView
 */
- (ModifyShippingAddressView *)citySelecteview
{
    if (_citySelecteview == nil) {
        
        _citySelecteview = [[[NSBundle mainBundle] loadNibNamed:@"ModifyShippingAddressView"
                                                          owner:self options:nil]lastObject];
    }
    return _citySelecteview;
}



- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
}

#pragma mark -UI
- (void)uiConfigAction
{
    self.generateOrderTableview.dataSource = self;
    self.generateOrderTableview.delegate = self;
    self.generateOrderTableview.tableFooterView = [UIView new];
}




- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    if (indexPath.section == 0 && indexPath.row == 0) {
        
        PersonInformationTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"secondcell" forIndexPath:indexPath];
        return cell;
    }
    else if (indexPath.section == 1)
    {
        if (indexPath.row == 1) {
            
            GenerateOrdersModifyTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"Modifycell" forIndexPath:indexPath];
            return cell;
        }
        GenerateOrdersTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"consigneecell" forIndexPath:indexPath];
        return cell;
    }
    else if (indexPath.section == 2)
    {

        if (indexPath.row == 1) {
            
            AllpriceTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"sixthcell" forIndexPath:indexPath];
            return cell;
        }
        CommodityListTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"fourthcell" forIndexPath:indexPath];
        
        return cell;
    }
    return nil;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    switch (section) {
        case 0:
        {
            return 1;
        }
            break;
        case 1:
        {
            return 2;
        }
            break;
        case 2:
        {
            return 2;
        }
            break;
            
        default:
            break;
    }
    return 0;
}


- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.section) {
        case 0:
        {
            return 160;
        }
            break;
        case 1:
        {
            return 56;
        }
            break;
        case 2:
        {
            if (indexPath.row == 1) {
                
                return 50;
            }
            return 80;
        }
            break;
            
        default:
            break;
    }
    return 0;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    switch (section) {
        case 0:
        {
            return 0;
        }
            break;
        case 1:
        {
            return 10;
        }
            break;
        case 2:
        {
            return 44;
        }
            break;
            
        default:
            break;
    }
    return 0;
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    UIView *view = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, 44)];
    view.backgroundColor = [UIColor redColor];
    return view;
}



- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 3;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [self CreateModifyShippingView];
}


#pragma mark -新增或者修改收货地址
- (void)CreateModifyShippingView
{
    //修改收货地址弹出框
    self.addressView = [[[NSBundle mainBundle] loadNibNamed:@"ModifyShippingAddressView" owner:self options:nil]firstObject];
    self.addressView.frame = CGRectMake(0, ScreenHeight+NavigationHeight, ScreenWidth, ScreenHeight);
    self.addressView.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.5];
    [self.addressView.turnoffButton addTarget:self action:@selector(TurnofffButtonClick) forControlEvents:UIControlEventTouchUpInside];
    [self.addressView.citySelected addTarget:self action:@selector(SelectedCityButtonClick) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:self.addressView];
    
    //tabbar遮罩
    self.Tabbarview = [[UIView alloc]initWithFrame:CGRectMake(0, ScreenHeight, ScreenWidth, NavigationHeight)];
    self.Tabbarview.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.5];
    [SHARED_APPDELEGATE.tabbar addSubview:self.Tabbarview];
    
    [UIView animateWithDuration:0.2 animations:^{
        
        self.Tabbarview.frame = CGRectMake(0, 0, ScreenWidth, NavigationHeight);
        self.addressView.frame = CGRectMake(0, 0, ScreenWidth, ScreenHeight);
    }];
    
}


#pragma mark -关闭按钮
- (void)TurnofffButtonClick
{
    [UIView animateWithDuration:0.2 animations:^{
        
        self.addressView.frame = CGRectMake(0, ScreenHeight+NavigationHeight, ScreenWidth, ScreenHeight);
        self.Tabbarview.frame = CGRectMake(0, ScreenHeight, ScreenWidth, NavigationHeight);
        
    }];
}




#pragma mark -生成订单
- (IBAction)CreateOrderButtonClick:(UIButton *)sender {
    
    OrderdetailsViewController *orderDetails = [[self getStoryboardWithName] instantiateViewControllerWithIdentifier:@"orderdetails"];
    [self.navigationController pushViewController:orderDetails animated:YES];
}


#pragma mark -返回购物车

- (IBAction)BackShoppingBagsButtonClick:(UIButton *)sender {
    
    [self.navigationController popViewControllerAnimated:YES];
}


#pragma mark -城市选择器
- (void)SelectedCityButtonClick
{

    self.citySelecteview.frame = CGRectMake(0, self.addressView.popupView.frame.size.height, self.addressView.popupView.frame.size.width, 160);
    [self.addressView.popupView addSubview:self.citySelecteview];
    [self.citySelecteview.selectedCityButton addTarget:self action:@selector(CompleteButton) forControlEvents:UIControlEventTouchUpInside];
    [UIView animateWithDuration:0.2 animations:^{
        
        self.citySelecteview.frame = CGRectMake(0, self.addressView.popupView.frame.size.height-160, self.addressView.popupView.frame.size.width, 160);
    }completion:^(BOOL finished) {
        
        self.addressView.citySelected.enabled = NO;
    }];
}


#pragma mark -完成按钮点击
- (void)CompleteButton
{
    [UIView animateWithDuration:0.2 animations:^{
        
        self.citySelecteview.frame = CGRectMake(0, ScreenHeight, self.addressView.popupView.frame.size.width, 160);
    }completion:^(BOOL finished) {
        
        [self.citySelecteview removeFromSuperview];
        self.citySelecteview = nil;
        self.addressView.citySelected.enabled = YES;
    }];
}







- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
