//
//  LoginViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/27.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "LoginViewController.h"
#import "CustomTabbarController.h"
#import "AppDelegate.h"
#import "authenticateView.h"




@interface LoginViewController ()<RightVCselectedDelegate>

@property (nonatomic,strong) MMDrawerController *drawerController;
@property (nonatomic,strong) CustomTabbarController *customtabbar;

/**
 *  验证身份View
 */
@property (nonatomic,strong) authenticateView *identityView;

/**
 *  重置密码View
 */
@property (nonatomic,strong) authenticateView *resetPasswordView;

@end

@implementation LoginViewController


- (CustomTabbarController *)customtabbar
{
    if (_customtabbar == nil) {
        
        _customtabbar = [[CustomTabbarController alloc]init];
    }
    return _customtabbar;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.

    
    [self uiConfigAction];
    
}


#pragma mark - 布局
- (void)uiConfigAction
{
    self.loginButton.layer.masksToBounds = YES;
    self.loginButton.layer.cornerRadius = kCornerRadius;
    self.userNameBackview.layer.masksToBounds = YES;
    self.userNameBackview.layer.cornerRadius = kCornerRadius;
    self.passWordBackview.layer.masksToBounds = YES;
    self.passWordBackview.layer.cornerRadius = kCornerRadius;
    self.userNameLoginView.layer.masksToBounds = YES;
    self.userNameLoginView.layer.cornerRadius = 10;
    self.forgotPasswordButton.titleLabel.font = [UIFont boldSystemFontOfSize:16];
    
    
    
    self.userName.text = @"sh1";
    self.passWord.text = @"123456";
    
}


#pragma mark -登陆
- (IBAction)LoginButtonClick:(UIButton *)sender {
    
    if (self.userName.text.length == 0) {

        [self ErrorMBProgressView:@"用户名不能为空"];
        return;
        
    }else if (self.passWord.text.length == 0)
    {
        [self ErrorMBProgressView:@"密码不能为空"];
        return;
    }
    
    [self judgeUserNameAndPassword];
}

#pragma mark -设置根视图控制器
- (void)SetTheRootViewController
{
        RightViewController *rightVC = [[RightViewController alloc]init];
        rightVC.delegate = self;
        self.drawerController = [[MMDrawerController alloc]initWithCenterViewController:self.customtabbar rightDrawerViewController:rightVC];
        [self.drawerController setMaximumRightDrawerWidth:RightWidth];
        [self.drawerController setOpenDrawerGestureModeMask:MMOpenDrawerGestureModeAll];
        [self.drawerController setCloseDrawerGestureModeMask:MMCloseDrawerGestureModeAll];
        SHARED_APPDELEGATE.mmdrawer = self.drawerController;
        SHARED_APPDELEGATE.window.rootViewController = self.drawerController;
}


#pragma mark -判断用户名密码是否正确
- (void)judgeUserNameAndPassword
{
    [self CreateMBProgressHUDLoding];
    NSString *URL = [NSString stringWithFormat:@"%@%@",ServerAddress,@"/employee/login"];
    LoginInfo *login = [[LoginInfo alloc]init];
    login.username = self.userName.text;
    login.password = self.passWord.text;
    
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:URL WithRequestType:0 WithParameter:login WithReturnValueBlock:^(id returnValue) {
        
        [self RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            
            LoginResult *result = [[LoginResult alloc] initWithDictionary:returnValue[@"data"]];
            
            [self SetTheRootViewController];
            NSLog(@"成功");
        }else
        {
            [self ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        
        NSLog(@"%@",errorCodeValue);
        
    } WithFailureBlock:^(id error) {
        
        [self RemoveMBProgressHUDLoding];
        
    }];
}




#pragma mark -RightVCselectedDelegate 方法
- (void)SelectedControllerWithIndex:(NSString *)Name
{
    NSInteger selectedIndex;
    if ([Name isEqualToString:@"体验中心"]) {
        
        selectedIndex = 6;
        
    }else if ([Name isEqualToString:@"场景库"])
    {
       selectedIndex = 5;
    }else if ([Name isEqualToString:@"产品库"])
    {
        selectedIndex = 4;
    }else if ([Name isEqualToString:@"客户管理"])
    {
       selectedIndex = 3;
    }else if ([Name isEqualToString:@"所有客户"])
    {
        selectedIndex = 2;
    }else if ([Name isEqualToString:@"客户订单"])
    {
        selectedIndex = 1;
    }else if ([Name isEqualToString:@"关于"])
    {
        selectedIndex = 0;
    }
    
    self.customtabbar.selectedIndex = selectedIndex;
}



#pragma mark -忘记密码
- (IBAction)ForgotpasswordButtonClick:(UIButton *)sender {
    
    
    self.identityView = [[[NSBundle mainBundle] loadNibNamed:@"authenticateView" owner:self options:nil]firstObject];
    
    //判断登陆界面是否已经输入了用户名
    if (self.userName.text.length != 0) {
        
        self.identityView.userName.text = self.userName.text;
    }
    
    
    self.identityView.layer.masksToBounds = YES;
    self.identityView.layer.cornerRadius = 10;
    [self.identityView.backLoginButton addTarget:self action:@selector(BackloginButtonClick) forControlEvents:UIControlEventTouchUpInside];
    [self.identityView.nextButton addTarget:self action:@selector(NextButtonClick) forControlEvents:UIControlEventTouchUpInside];
    self.identityView.alpha = 0;
    self.identityView.frame = self.userNameLoginView.frame;
    [self.view addSubview:self.identityView];
    [UIView animateWithDuration:0.2 animations:^{
        
        self.identityView.alpha = 1;
        
    }];
}




#pragma mark -返回登陆界面
- (void)BackloginButtonClick
{
    
    
    [UIView animateWithDuration:0.2 animations:^{
        
        self.identityView.alpha = 0;
        
    }completion:^(BOOL finished) {
        
        [self.identityView removeFromSuperview];
        
    }];
}



#pragma mark -下一步（重置密码界面）
- (void)NextButtonClick
{
    self.resetPasswordView = [[[NSBundle mainBundle] loadNibNamed:@"authenticateView" owner:self options:nil]lastObject];
    self.resetPasswordView.layer.masksToBounds = YES;
    self.resetPasswordView.layer.cornerRadius = 10;
    self.resetPasswordView.frame = self.userNameLoginView.frame;
    [self.resetPasswordView.backValidationView addTarget:self action:@selector(backButonClick) forControlEvents:UIControlEventTouchUpInside];
    [self.resetPasswordView.resetPasswordNextButton addTarget:self action:@selector(ChangPassWordRequest) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:self.resetPasswordView];
    self.resetPasswordView.alpha = 0;
    
    [UIView animateWithDuration:0.2 animations:^{
        
        self.resetPasswordView.alpha = 1;
    }];
}


#pragma mark -修改密码
- (void)ChangPassWordRequest
{
    
    NSLog(@"%@",self.resetPasswordView.newpass.text);
    NSLog(@"%@",self.resetPasswordView.confirmNewpass.text);
    
    if (self.resetPasswordView.newpass.text.length == 0) {
        
        [self ErrorMBProgressView:@"新密码为空"];
        return;
        
    }else if (self.resetPasswordView.confirmNewpass.text.length == 0)
    {
        [self ErrorMBProgressView:@"确认密码为空"];
        return;
    }
    
    if (![self.resetPasswordView.newpass.text isEqualToString:self.resetPasswordView.confirmNewpass.text]) {
        
        [self ErrorMBProgressView:@"两次密码不相同"];
        return;
    }
    
    
    //调用短信发送接口
    AFHTTPSessionManager *manager = [AFHTTPSessionManager manager];
    [manager.requestSerializer setValue:@"application/json;charset=utf-8" forHTTPHeaderField: @"Content-Type"];
    
    [manager GET:[NSString stringWithFormat:@"%@%@",ServerAddress,@"com.gomore.opple.rest.system.RsSystemService#sendSms(1234)"] parameters:nil progress:nil success:^(NSURLSessionDataTask * _Nonnull task, id  _Nullable responseObject) {
        
        NSLog(@"%@",responseObject);
        
    } failure:^(NSURLSessionDataTask * _Nullable task, NSError * _Nonnull error) {
        
        NSLog(@"%@",error);
    }];

    //重置密码接口
    ResetPasswordRequest *passwrod = [[ResetPasswordRequest alloc]init];
    passwrod.Password = self.resetPasswordView.newpass.text;
    passwrod.Password = self.resetPasswordView.confirmNewpass.text;
    
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:[NSString stringWithFormat:@"%@%@",ServerAddress,@"/employee/resetPassword"] WithRequestType:0 WithParameter:passwrod WithReturnValueBlock:^(id returnValue) {
        
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            
            [self ErrorMBProgressView:returnValue[@"message"]];
            
        }else
        {
           [self ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        
    } WithFailureBlock:^(id error) {
        
    }];
    
}



#pragma mark -返回验证信息界面
- (void)backButonClick
{
    [UIView animateWithDuration:0.2 animations:^{
        
        self.resetPasswordView.alpha = 0;
        
    } completion:^(BOOL finished) {
        
        [self.resetPasswordView removeFromSuperview];
    }];
}







- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
