//
//  NetworkRequestClassManager.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/28.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "NetworkRequestClassManager.h"
#import "AppDelegate.h"


@implementation NetworkRequestClassManager



static NetworkRequestClassManager *manager = nil;
/**
 *  网络请求单例
 *
 *  @return NetworkRequestClassManager
 */
+ (NetworkRequestClassManager *)Manager
{
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        manager = [[NetworkRequestClassManager alloc]init];
    });
    return manager;
}

+ (id)allocWithZone:(struct _NSZone *)zone
{
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        manager = [super allocWithZone:zone];
    });
    return manager;
}


/**
 *  网络请求
 *
 *  @param requestURLString     网址
 *  @param requestType          请求类型(POST/GET)
 *  @param parameter            参数
 *  @param sueecssBlock         成功回调
 *  @param errorCodeBlock       错误编码回调
 *  @param failureBlock         失败回调
 */

- (void)NetworkRequestWithURL:(NSString *) requestURLString
              WithRequestType:(NetworkRequestType) requestType
                WithParameter:(JSONModel *) jastorobject
         WithReturnValueBlock:(ReturnValueBlock) successBlock
           WithErrorCodeBlock:(ErrorCodeBlock) errorCodeBlock
             WithFailureBlock:(FailureBlock) failureBlock

{
    
    AFHTTPSessionManager *manager = [AFHTTPSessionManager manager];
    manager.responseSerializer = [AFJSONResponseSerializer serializer];
    manager.requestSerializer = [AFJSONRequestSerializer serializer];
    manager.requestSerializer.timeoutInterval = 10.0f;
    [manager.requestSerializer setValue:@"application/json;charset=utf-8" forHTTPHeaderField: @"Content-Type"];

    //网络检测
    if (SHARED_APPDELEGATE.Networkstatus == false) {
        
        errorCodeBlock(BROKEN);
        return;
    }
    
    if (requestType == 0) {
        
        
        [manager POST:requestURLString parameters:[jastorobject toDictionary] progress:nil success:^(NSURLSessionDataTask * _Nonnull task, id  _Nullable responseObject) {
            
            successBlock(responseObject);
            
        } failure:^(NSURLSessionDataTask * _Nullable task, NSError * _Nonnull error) {
            
            failureBlock(error);
            
        }];
        
    }else if (requestType == 1){
        
        [manager GET:requestURLString parameters:[jastorobject toDictionary] progress:nil success:^(NSURLSessionDataTask * _Nonnull task, id  _Nullable responseObject) {
            
            successBlock(responseObject);
            
        } failure:^(NSURLSessionDataTask * _Nullable task, NSError * _Nonnull error) {
            
            failureBlock(error);
            
        }];
    }
}


/**
 *  网络请求
 *
 *  @param requestURLString     网址
 *  @param requestType          请求类型
 *  @param parameter            字典对象
 *  @param sueecssBlock         成功回调
 *  @param errorCodeBlock       错误编码回调
 *  @param failureBlock         失败回调
 */
- (void)NetworkWithDictionaryRequestWithURL:(NSString *) requestURLString
                            WithRequestType:(NetworkRequestType) requestType
                              WithParameter:(NSDictionary *) parameter
                       WithReturnValueBlock:(ReturnValueBlock) successBlock
                         WithErrorCodeBlock:(ErrorCodeBlock) errorCodeBlock
                           WithFailureBlock:(FailureBlock) failureBlock
{
    AFHTTPSessionManager *manager = [AFHTTPSessionManager manager];
    manager.responseSerializer = [AFJSONResponseSerializer serializer];
    manager.requestSerializer = [AFJSONRequestSerializer serializer];
    manager.requestSerializer.timeoutInterval = 10.0f;
    [manager.requestSerializer setValue:@"application/json;charset=utf-8" forHTTPHeaderField: @"Content-Type"];
    
    //网络检测
    if (SHARED_APPDELEGATE.Networkstatus == false) {
        
        errorCodeBlock(BROKEN);
        return;
    }
    
    if (requestType == 0) {
        
        [manager POST:requestURLString parameters:parameter progress:nil success:^(NSURLSessionDataTask * _Nonnull task, id  _Nullable responseObject) {
            
            successBlock(responseObject);
            
        } failure:^(NSURLSessionDataTask * _Nullable task, NSError * _Nonnull error) {
            
            failureBlock(error);
            
        }];
        
    }else if (requestType == 1){
        
        [manager GET:requestURLString parameters:parameter progress:nil success:^(NSURLSessionDataTask * _Nonnull task, id  _Nullable responseObject) {
            
            successBlock(responseObject);
            
        } failure:^(NSURLSessionDataTask * _Nullable task, NSError * _Nonnull error) {
            
            failureBlock(error);
            
        }];
    }
}























@end
