//
//  ScreeningView.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/7.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ScreeningView.h"

@implementation ScreeningView

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/


- (void)awakeFromNib
{
    [self uiConfigAction];
}


#pragma mark -UI
- (void)uiConfigAction
{
    self.styleButton.layer.masksToBounds = YES;
    self.styleButton.layer.cornerRadius = kSelectedCornerRadius;
    self.typeButton.layer.masksToBounds = YES;
    self.typeButton.layer.cornerRadius = kSelectedCornerRadius;
    self.spaceButton.layer.masksToBounds = YES;
    self.spaceButton.layer.cornerRadius = kSelectedCornerRadius;
    self.materialButton.layer.masksToBounds = YES;
    self.materialButton.layer.cornerRadius = kSelectedCornerRadius;
    self.spriceButton.layer.masksToBounds = YES;
    self.spriceButton.layer.cornerRadius = kSelectedCornerRadius;
    
    //默认选中风格按钮
    self.styleButton.selected = YES;
    self.styleButton.backgroundColor = kMainBlueColor;
    
//    //添加阴影
//    self.shadowView.layer.shadowColor = [UIColor blackColor].CGColor;
//    self.shadowView.layer.shadowRadius = 4;
//    self.shadowView.layer.shadowOpacity = 0.8;
}


#pragma mark -筛选按钮(风格、类型、空间、材质、价格)
- (IBAction)screeningButtonClick:(UIButton *)sender {
    
    switch (sender.tag) {
        case 100://风格
        {
            
        }
            break;
        case 101://类型
        {
            
        }
            break;
        case 102://空间
        {
            
        }
            break;
        case 103://材质
        {
            
        }
            break;
        case 104://价格
        {
            
        }
            break;
            
        default:
            break;
    }
    
    if ([self.delegate respondsToSelector:@selector(screeningButtonClick:)]) {
        
        [self.delegate screeningButtonClick:sender.tag-100];
    }
    
    [self RemoveAllButtonisSelected];
    sender.selected = YES;
    sender.backgroundColor = kMainBlueColor;
}


#pragma mark -取消所有筛选条件按钮的选中
- (void)RemoveAllButtonisSelected
{
    for (UIView *view in self.backgroundView.subviews) {
        
        if ([view isKindOfClass:[UIButton class]]) {
            
            UIButton *button = (UIButton *)view;
            button.selected = NO;
            button.backgroundColor = [UIColor whiteColor];
        }
    }
}


#pragma mark -切换按钮的选中状态
- (void)setIndexselected:(NSInteger)indexselected
{
    _indexselected = indexselected;
    UIButton *buttonn = [self viewWithTag:100+indexselected];
    [self RemoveAllButtonisSelected];
    buttonn.selected = YES;
    buttonn.backgroundColor = kMainBlueColor;
}











@end
