//
//  SceneLibraryViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/4.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "SceneLibraryViewController.h"
#import "SeceneLibraryCollectionViewCell.h"

@interface SceneLibraryViewController ()<UICollectionViewDelegate,UICollectionViewDataSource>



/**
 *  筛选数据源
 */
@property (nonatomic,strong)  SceneFilter *filter;

/**
 *  列表数据
 */
@property (nonatomic,strong) SceneResponse *response;
@end

@implementation SceneLibraryViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    [self uiConfigAction];
    [self getdatasAction];
    [self getSceneLibrarydatas];
}

#pragma mark -UI
- (void)uiConfigAction
{
    self.seceneLibraryCollectionLayout.itemSize = CGSizeMake((ScreenWidth-6)/3, (ScreenWidth-6)/3-50);
    self.seceneLibraryCollectionLayout.minimumLineSpacing = 2;
    self.seceneLibraryCollectionLayout.minimumInteritemSpacing = 2;
    self.seceneLibraryCollectionLayout.sectionInset = UIEdgeInsetsMake(5, 0, 5, 0);
    self.seceneLibararyCollectionView.dataSource = self;
    self.seceneLibararyCollectionView.delegate = self;
}


#pragma mark -获取场景筛选数据
- (void)getdatasAction
{
  
    [self CreateMBProgressHUDLoding];
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:[NSString stringWithFormat:@"%@%@",ServerAddress,@"/scene/getSceneFilter"] WithRequestType:1 WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        [self RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            
          self.filter = [[SceneFilter alloc]initWithDictionary:returnValue[@"data"] error:nil];
    
        }
        else
        {
            [self ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        
    } WithFailureBlock:^(id error) {
        
        [self RemoveMBProgressHUDLoding];
    }];
}


#pragma mark -获取场景列表数据
- (void)getSceneLibrarydatas
{
    
    SceneCondition *condition = [[SceneCondition alloc]init];
    DataPage *page = [[DataPage alloc]init];
    page.page = 0;
    condition.page = page;
    
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:[NSString stringWithFormat:@"%@%@",ServerAddress,@"/scene/query"] WithRequestType:0 WithParameter:condition WithReturnValueBlock:^(id returnValue) {
        
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            
            NSLog(@"%@",returnValue);
            self.response = [[SceneResponse alloc]initWithDictionary:returnValue[@"data"] error:nil];
            
        }
        else
        {
            [self ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        
    } WithFailureBlock:^(id error) {
        
        
    }];
}



- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    SeceneLibraryCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"secenelibrary" forIndexPath:indexPath];
    
    return cell;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return 20;
}


#pragma mark -切换显示风格
- (IBAction)SwitchdisplayStyleClick:(UIButton *)sender {
    
    self.seceneLibraryCollectionLayout.itemSize = CGSizeMake((ScreenWidth-10)/6, (ScreenWidth-10)/6-50);
    [self.seceneLibararyCollectionView reloadData];
    
}


#pragma mark -筛选风格
- (IBAction)screeningStyleButtonClick:(UIButton *)sender {
    
    PopoverViewController *popover = [[PopoverViewController alloc]init];
    popover.datasArray = @[@"你好",@"你好"];
    popover.contentSize = CGSizeMake(150, 300);
    popover.preferredContentSize = CGSizeMake(150, 300);
    popover.modalPresentationStyle = UIModalPresentationPopover;
    UIPopoverPresentationController *pop = popover.popoverPresentationController;
    pop.permittedArrowDirections = UIPopoverArrowDirectionAny;
    pop.sourceView = popover.view;
    pop.barButtonItem = [[UIBarButtonItem alloc]initWithCustomView:sender];
    [self presentViewController:popover animated:YES completion:nil];
    
}


#pragma mark -房型风格
- (IBAction)HouseStyleButtonClick:(UIButton *)sender {
    
    PopoverViewController *popover = [[PopoverViewController alloc]init];
    popover.datasArray = @[@"你好",@"你好"];
    popover.contentSize = CGSizeMake(150, 300);
    popover.preferredContentSize = CGSizeMake(150, 300);
    popover.modalPresentationStyle = UIModalPresentationPopover;
    UIPopoverPresentationController *pop = popover.popoverPresentationController;
    pop.permittedArrowDirections = UIPopoverArrowDirectionAny;
    pop.sourceView = popover.view;
    pop.barButtonItem = [[UIBarButtonItem alloc]initWithCustomView:sender];
    [self presentViewController:popover animated:YES completion:nil];
}




- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
