//
//  OrderdetailsViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/4.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "OrderdetailsViewController.h"
#import "OrderInformationTableViewCell.h"
#import "PersonInformationTableViewCell.h"
#import "GoodsInformationTableViewCell.h"
#import "CommodityListTableViewCell.h"
#import "AllpriceTableViewCell.h"
#import "AttachmentInformationTableViewCell.h"
#import "SettlementViewController.h"

@interface OrderdetailsViewController ()<UITableViewDelegate,UITableViewDataSource>

@end

@implementation OrderdetailsViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
}



#pragma mark - UI
- (void)uiConfigAction
{
    self.orderDetailsTableview.dataSource = self;
    self.orderDetailsTableview.delegate = self;
//    self.orderDetailsTableview.tableFooterView = [UIView new];
    
    [self CreateTableviewHeaderView];
    [self CreateTableviewFooterView];
}

#pragma mark -TableviewHeader------根据不同的订单状态判断是否显示
- (void)CreateTableviewHeaderView
{
    UIView *headerView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, 60)];
    
    //预览
    UIButton *previewButton = [UIButton buttonWithType:UIButtonTypeSystem];
    previewButton.frame = CGRectMake(50, 15, 150, 30);
    [previewButton setTitle:@"预览" forState:UIControlStateNormal];
    previewButton.titleLabel.font = [UIFont systemFontOfSize:12];
    [previewButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    [previewButton addTarget:self action:@selector(PreviewButtonClick:) forControlEvents:UIControlEventTouchUpInside];
    previewButton.backgroundColor = kMainBlueColor;
    previewButton.layer.masksToBounds = YES;
    previewButton.layer.cornerRadius = kCornerRadius;
    [headerView addSubview:previewButton];
    
    //打印
    UIButton *printButton = [UIButton buttonWithType:UIButtonTypeSystem];
    printButton.frame = CGRectMake(ScreenWidth-50-150, 15, 150, 30);
    [printButton setTitle:@"打印" forState:UIControlStateNormal];
    [printButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    printButton.titleLabel.font = [UIFont systemFontOfSize:12];
    [printButton addTarget:self action:@selector(AirprintButtonClick:) forControlEvents:UIControlEventTouchUpInside];
    printButton.layer.masksToBounds = YES;
    printButton.layer.cornerRadius = kCornerRadius;
    printButton.backgroundColor = kMainBlueColor;
    [headerView addSubview:printButton];
    
    //横线
    UIView *lineView = [[UIView alloc]initWithFrame:CGRectMake(0, 59, ScreenWidth, 1)];
    lineView.backgroundColor = kTCColor(193, 193, 193);
    [headerView addSubview:lineView];
    
    self.orderDetailsTableview.tableHeaderView = headerView;
}

#pragma mark -TableviewFooterView------根据不同的订单状态判断支付按钮是否显示
- (void)CreateTableviewFooterView
{
    UIView *footerView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, 100)];
    
    //支付
    UIButton *payButton = [UIButton buttonWithType:UIButtonTypeSystem];
    payButton.frame = CGRectMake((ScreenWidth-150)/2, 30, 150, 40);
    [payButton setTitle:@"支付" forState:UIControlStateNormal];
    payButton.titleLabel.font = [UIFont systemFontOfSize:12];
    [payButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    [payButton addTarget:self action:@selector(PayButtonClick) forControlEvents:UIControlEventTouchUpInside];
    payButton.backgroundColor = kMainBlueColor;
    payButton.layer.masksToBounds = YES;
    payButton.layer.cornerRadius = kCornerRadius;
    [footerView addSubview:payButton];
    self.orderDetailsTableview.tableFooterView = footerView;
}




#pragma mark -调出支付框
- (void)PayButtonClick
{
    SettlementViewController *settlement = [[SettlementViewController alloc]init];
    settlement.preferredContentSize = CGSizeMake(380, 500);
    settlement.modalPresentationStyle = UIModalPresentationFormSheet;
    UIPopoverPresentationController *pop = settlement.popoverPresentationController;
    pop.sourceView = settlement.view;
    pop.permittedArrowDirections = UIPopoverArrowDirectionAny;
    [self presentViewController:settlement animated:YES completion:nil];
}


#pragma mark - Table view data source
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    
    switch (section) {
        case 0:
        {
            return 1;
        }
            break;
        case 1:
        {
            return 1;
        }
            break;
        case 2:
        {
            return 1;
        }
            break;
        case 3:
        {
            return 3;
        }
            break;
        case 4:
        {
           return 1;
        }
            break;
            
        default:
            break;
    }
    return 0;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    switch (indexPath.section) {
        case 0://订单信息
        {
            OrderInformationTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"firstcell" forIndexPath:indexPath];
            return cell;
        }
            break;
        case 1://客户信息
        {
            PersonInformationTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"secondcell" forIndexPath:indexPath];
            return cell;
        }
            break;
        case 2://收货信息
        {
            GoodsInformationTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"thirdcell" forIndexPath:indexPath];
            return cell;
        }
            break;
        case 3://商品清单
        {
            if (indexPath.row == 2) {
                
                //商品总计
                AllpriceTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"sixthcell" forIndexPath:indexPath];
                return cell;
                
            }else
            {
                //单个商品
                CommodityListTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"fourthcell" forIndexPath:indexPath];
                return cell;
            }
        }
            break;
        case 4://附件信息
        {
            AttachmentInformationTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"fifthcell" forIndexPath:indexPath];
            return cell;
        }
            break;
            
        default:
            break;
    }
    return nil;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.section) {
        case 0:
        {
            return 84;
        }
            break;
        case 1:
        {
            return 160;
        }
            break;
        case 2:
        {
            return 110;
        }
            break;
        case 3:
        {
            //商品总计
            if (indexPath.row == 2) {
                
                return 50;
            }
            else
            {
            //单个商品
               return 80;
            }
        }
            break;
        case 4:
        {
            return 75;
        }
            break;
            
        default:
            break;
    }
    return 100;
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    
        
    UIView *view = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, 44)];
    view.backgroundColor = kMainGrayColor;
    
    //区头文字
    UILabel *Titlelabe = [[UILabel alloc]initWithFrame:CGRectMake(0, 10, ScreenWidth, 34)];
    Titlelabe.backgroundColor = [UIColor whiteColor];
    Titlelabe.text = @"    订单详情";
    Titlelabe.font = [UIFont systemFontOfSize:13];
    [view addSubview:Titlelabe];
    return view;
}



- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 44;
}



- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 5;
}






#pragma mark -打印订单
- (void)AirprintButtonClick:(UIButton *)button
{
    [self callAirprintWithdata:nil];
}




#pragma mark -预览订单
- (void)PreviewButtonClick:(UIButton *)button
{
    
}









/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


@end
