//
//  AppDelegate.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/27.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "AppDelegate.h"
#import "LoginViewController.h"
#import "DeviceDirectionManager.h"
#import <Bugly/Bugly.h>
#import <PgyUpdate/PgyUpdateManager.h>

@interface AppDelegate ()

@end

@implementation AppDelegate


- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    // Override point for customization after application launch.

    [self setUpBuglyAndPgy];
    [self detectionNetwork];
    [self SetIQKeyboardManager];
    [self RootViewcontroller];
    [self setUMShare];
    return YES;
}

#pragma mark - 设置bugly和pgy
- (void)setUpBuglyAndPgy
{
    [Bugly startWithAppId:@"900033734"];
    [[PgyUpdateManager sharedPgyManager] startManagerWithAppId:@"95fcb4e47cf3d6c7309a2760ccccde66"];
    [[PgyUpdateManager sharedPgyManager] checkUpdate];
}

- (UIInterfaceOrientationMask)application:(UIApplication *)application supportedInterfaceOrientationsForWindow:(nullable UIWindow *)window
{
    //判断是否是横屏
    if ( [[DeviceDirectionManager instance] isHorizontal]) {
        return UIInterfaceOrientationMaskAll ;
    } else{
       return UIInterfaceOrientationMaskLandscape;
    }
}

//分享回调
- (BOOL)application:(UIApplication *)application openURL:(NSURL *)url sourceApplication:(NSString *)sourceApplication annotation:(id)annotation
{
    BOOL result = [UMSocialSnsService handleOpenURL:url];
    if (result == FALSE) {
        //调用其他SDK，例如支付宝SDK等
    }
    return result;
}
#pragma mark -设置根视图
- (void)RootViewcontroller
{
    UIStoryboard *story = [UIStoryboard storyboardWithName:@"StoryboardwithCYX" bundle:nil];
    LoginViewController *login = [story instantiateViewControllerWithIdentifier:@"Login"];
    self.window.rootViewController = login;
}


#pragma mark -接收到内存警告
- (void)applicationDidReceiveMemoryWarning:(UIApplication *)application
{
    [[SDImageCache sharedImageCache] clearDisk];
    [[SDImageCache sharedImageCache] setValue:nil forKey:@"memCache"];
}


#pragma mark - 键盘
- (void)SetIQKeyboardManager
{
    IQKeyboardManager *manager = [IQKeyboardManager sharedManager];
    [[IQKeyboardManager sharedManager]setKeyboardDistanceFromTextField:0];
    manager.enable = YES;
    manager.shouldResignOnTouchOutside = YES;
    manager.enableAutoToolbar = NO;
}


#pragma mark -检测网络的可连接性
- (void)detectionNetwork
{
    self.Networkstatus = true;
    [[AFNetworkReachabilityManager sharedManager] startMonitoring];
    [[AFNetworkReachabilityManager sharedManager] setReachabilityStatusChangeBlock:^(AFNetworkReachabilityStatus status) {
        
        switch (status) {
                
            case AFNetworkReachabilityStatusUnknown:
            case AFNetworkReachabilityStatusNotReachable:{
                
                NSLog(@"无网络");
                self.Networkstatus = false;
                break;
            }
            case AFNetworkReachabilityStatusReachableViaWiFi:{
                
                NSLog(@"WiFi网络");
                self.Networkstatus = true;
                break;
                
            }
            case AFNetworkReachabilityStatusReachableViaWWAN:{
                
                NSLog(@"流量网络");
                self.Networkstatus = true;
                break;
            }
            default:
                break;
        }
    }];
}

#pragma mark - 友盟
-(void)setUMShare
{
    // 友盟分享初始化
    [UMSocialData setAppKey:@"57425f2467e58e645f00210a"];
    
    // 设置微信AppId、appSecret，分享url
    [UMSocialWechatHandler setWXAppId:@"wxab385878d9441f23" appSecret:@"58b85af13973bdf597fa807208ac0dff " url:@"http://www.umeng.com/social"];
    
    // 设置微博的AppKey、appSecret，分享url
    [UMSocialSinaSSOHandler openNewSinaSSOWithAppKey:@"1111393286" secret:@"5d011c05122b5539ec9592372f944d3c" RedirectURL:@"http://sns.whalecloud.com/sina2/callback"];
}


#pragma mark -更新通知
- (void)updateVersion
{
    [[NSNotificationCenter defaultCenter] postNotificationName:UPLOADVERSION object:nil];
}


- (void)applicationWillResignActive:(UIApplication *)application {
    // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
    // Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
}

- (void)applicationDidEnterBackground:(UIApplication *)application {
    // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
    // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
}

- (void)applicationWillEnterForeground:(UIApplication *)application {
    // Called as part of the transition from the background to the inactive state; here you can undo many of the changes made on entering the background.
//    [self updateVersion];
}

- (void)applicationDidBecomeActive:(UIApplication *)application {
    // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
}

- (void)applicationWillTerminate:(UIApplication *)application {
    // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
    // Saves changes in the application's managed object context before the application terminates.
}



@end
