//
//  PaymentsViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/8/26.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "PaymentsViewController.h"
#import "PaymentsTableViewCell.h"
#import "PaymentsDetailsTableViewController.h"


@interface PaymentsViewController ()<UITableViewDelegate,UITableViewDataSource,DZNEmptyDataSetSource,DZNEmptyDataSetDelegate>

@property (weak, nonatomic) IBOutlet UITableView *paymentsTableView;
/**
 *  上传参数
 */
@property (nonatomic,strong) RsCommissionRequest *model;

/**
 *  数据源
 */
@property (nonatomic,strong) NSMutableArray  *resultArray;

/**
 *  总页数
 */
@property (nonatomic,assign) NSInteger totalPage;

@end

@implementation PaymentsViewController


#pragma mark - lazy
- (RsCommissionRequest *)model
{
    if (!_model) {
        _model = [[RsCommissionRequest alloc]init];
        DataPage *page = [[DataPage alloc]init];
        page.page = ONE;
        page.rows = KROWS;
        _model.page = page;
        _model.emploreeId = [Shoppersmanager manager].Shoppers.employee.fid;
    }
    return _model;
}

- (NSMutableArray *)resultArray
{
    if (!_resultArray) {
        _resultArray = [NSMutableArray array];
    }
    return _resultArray;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.paymentsTableView.tableFooterView = [UIView new];
    [self setupRefreshing];
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    [self.paymentsTableView.mj_header beginRefreshing];
}

#pragma mark - 设置刷新
- (void)setupRefreshing
{
    WS(weakSelf);
    MjRefreshHeaderCustom *headerRefresh = [MjRefreshHeaderCustom headerWithRefreshingBlock:^{
        weakSelf.model.page.page = ONE;
        [weakSelf.paymentsTableView.mj_footer resetNoMoreData];
        [weakSelf getDatasAction:YES];
    }];
    headerRefresh.stateLabel.hidden = YES;
    headerRefresh.lastUpdatedTimeLabel.hidden = YES;
    self.paymentsTableView.mj_header = headerRefresh;
    
    MJRefreshAutoNormalFooter *footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
        if (++ weakSelf.model.page.page >= weakSelf.totalPage) {
            [weakSelf.paymentsTableView.mj_footer endRefreshingWithNoMoreData];
        }else
        {
            [weakSelf getDatasAction:NO];
        }
    }];
    footer.automaticallyHidden = YES;
    self.paymentsTableView.mj_footer = footer;
}

#pragma mark - 获取收支明细
- (void)getDatasAction:(BOOL)isRemoveAll
{
    WS(weakSelf);
    [self CreateMBProgressHUDLoding];
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(PAYMENTS) WithCallClass:weakSelf WithRequestType:0 WithParameter:self.model WithReturnValueBlock:^(id returnValue) {
        
        weakSelf.paymentsTableView.emptyDataSetSource = self;
        weakSelf.paymentsTableView.emptyDataSetDelegate = self;
        [weakSelf endRefreshingForTableView:weakSelf.paymentsTableView];
        [weakSelf RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            if (isRemoveAll) {
                [weakSelf.resultArray removeAllObjects];
            }
            RsCommissionResponse *result = [[RsCommissionResponse alloc]initWithDictionary:returnValue[@"data"] error:nil];
            weakSelf.totalPage = result.totalpages;
            for (TOCommissionHistEntity *entity in result.list) {
                [weakSelf.resultArray addObject:entity];
            }
            [weakSelf.paymentsTableView reloadData];
        }else
        {
            [weakSelf SHOWPrompttext:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf endRefreshingForTableView:weakSelf.paymentsTableView];
        [weakSelf SHOWPrompttext:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf endRefreshingForTableView:weakSelf.paymentsTableView];
        [weakSelf SHOWPrompttext:error.localizedDescription];
    }];
}

#pragma mark - <UITableViewDataSource,UITableViewDelegate>
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    PaymentsTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"PaymentsTableViewCell" forIndexPath:indexPath];
    TOCommissionHistEntity *entity = self.resultArray[indexPath.row];
    cell.createTimeLabel.text = entity.createDate;
    cell.moneyTypeLabel.text = [self separatePaymentsAndWithfrawal:entity.state];
    NSString *string = ([entity.amount floatValue] > 0)?[NSString stringWithFormat:@"+%.2f",[entity.amount floatValue]]:[NSString stringWithFormat:@"%.2f",[entity.amount floatValue]];
    cell.amountLabel.text = string;
    return cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.resultArray.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 70;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    PaymentsDetailsTableViewController *paymentsDetailsVC = [[self getStoryboardWithName] instantiateViewControllerWithIdentifier:@"PaymentsDetailsTableViewController"];
    paymentsDetailsVC.model = self.resultArray[indexPath.row];
    [self.navigationController pushViewController:paymentsDetailsVC animated:YES];
}

#pragma mark - 区分提现还是返佣
- (NSString *)separatePaymentsAndWithfrawal:(NSString *)state
{
    if ([state isEqualToString:@"0"]) {
        return @"返佣";
    }
    if ([state isEqualToString:@"1"]) {
        return @"提现";
    }
    return nil;
}

#pragma mark -友好界面
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView
{
    return kNoDataImage;
}

- (BOOL)emptyDataSetShouldAllowScroll:(UIScrollView *)scrollView
{
    return YES;
}

- (NSAttributedString *)titleForEmptyDataSet:(UIScrollView *)scrollView
{
    return [[NSAttributedString alloc]initWithString:@"暂无数据" attributes:nil];
}

- (CGFloat)verticalOffsetForEmptyDataSet:(UIScrollView *)scrollView
{
    return 64;
}


@end
