//
//  CardDetailsViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/10/19.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CardDetailsViewController.h"
#import "CardDontUseViewController.h"
#import "CardBeenUseViewController.h"

@interface CardDetailsViewController ()

/**
 *  当前的控制器
 */
@property (nonatomic,strong) UIViewController *currentVC;

@end

@implementation CardDetailsViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self addChildViewController];
}

#pragma mark - 添加卡劵详情vc
- (void)addChildViewController
{
    // 未领取
    CardDontUseViewController *dontUseVc = [[self getStoryboardWithName] instantiateViewControllerWithIdentifier:@"CardDontUseViewController"];
    [self addChildViewController:dontUseVc];
    // 已领取
    CardBeenUseViewController *beenUseVc = [[self getStoryboardWithName] instantiateViewControllerWithIdentifier:@"CardBeenUseViewController"];
    beenUseVc.cardState = ACTIVED;
    [self addChildViewController:beenUseVc];
    // 已使用
    CardBeenUseViewController *usedVc = [[self getStoryboardWithName] instantiateViewControllerWithIdentifier:@"CardBeenUseViewController"];
    usedVc.cardState = USED;
    [self addChildViewController:usedVc];
    dontUseVc.view.frame = CGRectMake(0, 0, self.cardBackgroundView.mj_w, self.cardBackgroundView.mj_h);
    beenUseVc.view.frame = CGRectMake(0, 0, self.cardBackgroundView.mj_w, self.cardBackgroundView.mj_h);
    usedVc.view.frame = CGRectMake(0, 0, self.cardBackgroundView.mj_w, self.cardBackgroundView.mj_h);
    [self.cardBackgroundView addSubview:dontUseVc.view];
    self.currentVC = dontUseVc;
}


#pragma mark - 切换已使用卡劵、未使用卡劵
- (void)switchPaymentsVCAndWithdrawalVC:(UIViewController *)newViewController
{
    [self transitionFromViewController:self.currentVC toViewController:newViewController duration:0.5 options:UIViewAnimationOptionTransitionNone animations:nil completion:^(BOOL finished) {
        if (finished) {
            [self.cardBackgroundView addSubview:newViewController.view];
            self.currentVC = newViewController;
        }
    }];
}

#pragma mark - 切换ContentController
- (IBAction)paymentsButtonAndWithdrawalButtonClick:(UIButton *)sender {
    
    switch (sender.tag) {
        case 100:
        {
            self.beenUseButton.selected = NO;
            self.isUsedButton.selected = NO;
            
        }
            break;
        case 101:
        {
            self.dontUseButton.selected = NO;
            self.isUsedButton.selected = NO;
        }
            break;
        case 102:
        {
            self.dontUseButton.selected = NO;
            self.beenUseButton.selected = NO;
        }
            break;
            
        default:
            break;
    }
    sender.selected = YES;
    [self setupInstructionsViewOrigin:sender];
    [self switchPaymentsVCAndWithdrawalVC:self.childViewControllers[sender.tag-100]];
}

#pragma mark - 设置指示线的位置
- (void)setupInstructionsViewOrigin:(UIButton *)sender
{
    [UIView animateWithDuration:0.5 delay:0.1f usingSpringWithDamping:0.5f initialSpringVelocity:0.5f options:UIViewAnimationOptionCurveEaseInOut animations:^{
        self.instructionsLineView.frame = CGRectMake(sender.mj_origin.x+(sender.mj_w-self.instructionsLineView.mj_w)/2, self.instructionsLineView.mj_origin.y, self.instructionsLineView.mj_w, 2);
    } completion:nil];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}


@end
