//
//  PromotionChooseViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/14.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "PromotionChooseViewController.h"
#import "PromotionChooseTableViewCell.h"
#import "PromotionWeChatCardModel.h"
#import "PromotionalGoodsModel.h"
#import "PromotionalDeductionModel.h"
#import "PromotionLuckyDrawModel.h"

@interface PromotionChooseViewController ()<UITableViewDelegate,UITableViewDataSource>


/**
 自定义促销列表
 */
@property (nonatomic,strong) NSMutableArray *customPromotionDatas;

@end

@implementation PromotionChooseViewController


- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpTableView];
}

#pragma mark - 数据源
- (void)setPromotionDatasArray:(NSArray<JSONModel *> *)promotionDatasArray
{
    _promotionDatasArray = promotionDatasArray;
    NSMutableArray *promotionArray = [NSMutableArray array];
    [_promotionDatasArray enumerateObjectsUsingBlock:^(JSONModel * _Nonnull model, NSUInteger index, BOOL * _Nonnull stop) {
        CustomPromotionModel *promotionModel = [[CustomPromotionModel alloc]initCustomPromotionModel:model];
        [promotionArray addObject:promotionModel];
    }];
    //促销列表按降序排列
    self.customPromotionDatas = [NSMutableArray arrayWithArray:[promotionArray sortedArrayUsingComparator:^NSComparisonResult(CustomPromotionModel *obj1, CustomPromotionModel *obj2) {
        if (obj1.priority < obj2.priority) {
            return NSOrderedAscending;
        }
        if (obj1.priority < obj2.priority) {
            return NSOrderedDescending;
        }
        return NSOrderedSame;
    }]];
    [self calculatedPromotionConflicts:0];
}

#pragma mark - 选择促销后计算是否存在冲突
- (void)calculatedPromotionConflicts:(NSInteger)cellIndex
{
    WS(weakSelf);
    //默认选中最高级别促销及衍生促销
    CustomPromotionModel *promotionModel = self.customPromotionDatas[cellIndex];
    if (promotionModel.isSelected) {
        return;
    }else {
        for (CustomPromotionModel *model in self.customPromotionDatas) {
            model.isSelected = NO;
        }
        promotionModel.isSelected = YES;
    }
    [self.customPromotionDatas enumerateObjectsUsingBlock:^(CustomPromotionModel *model1, NSUInteger index, BOOL * _Nonnull stop) {
        if (![promotionModel.conflicts containsObject:model1.type] && ![model1.conflicts containsObject:promotionModel.type]) {
            for (NSInteger i=0;i<weakSelf.customPromotionDatas.count;i++) {
                CustomPromotionModel *model2 = weakSelf.customPromotionDatas[i];
                if (![model2.conflicts containsObject:model1.type] && ![model1.conflicts containsObject:model2.type] && ![model2 isEqual:promotionModel]) {
                    model1.isSelected = YES;break;
                }
            }
        }else {
            model1.isSelected = NO;
        }
    }];
    [self.promotionChooseTableView reloadData];
}

#pragma mark - UITableview
- (void)setUpTableView
{
    self.promotionChooseTableView.tableFooterView = [UIView new];
}

#pragma mark - <UITableViewDelegate,UITableViewDataSource>
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    PromotionChooseTableViewCell *chooseCell = [tableView dequeueReusableCellWithIdentifier:@"PromotionChooseTableViewCell" forIndexPath:indexPath];
    CustomPromotionModel *model = self.customPromotionDatas[indexPath.row];
    chooseCell.promotionModel = model;
    chooseCell.accessoryType = model.isSelected?UITableViewCellAccessoryCheckmark:UITableViewCellAccessoryNone;
    chooseCell.selectionStyle = UITableViewCellSelectionStyleNone;
    return chooseCell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.customPromotionDatas.count;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [self calculatedPromotionConflicts:indexPath.row];
}

#pragma mark - 退出促销条件选择
- (IBAction)dismissPromotionChooseNavigation:(UIBarButtonItem *)sender {
    [self dismissViewControllerAnimated:YES completion:nil];
}

#pragma mark - 确认促销条件选择
- (IBAction)confirmPromotionChoose:(UIBarButtonItem *)sender {
    [self dismissViewControllerAnimated:YES completion:nil];
    if ([self.promotionDelegate respondsToSelector:@selector(confirmChoosePromotion:)]) {
        NSMutableArray *chooseArray = [NSMutableArray array];
        for (CustomPromotionModel *model in self.customPromotionDatas) {
            if (model.isSelected) {
                [chooseArray addObject:model];
            }
        }
        [self.promotionDelegate confirmChoosePromotion:chooseArray];
    }
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}


@end
