//
//  GuideIntegralViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/16.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "GuideIntegralViewController.h"
#import "PaymentsViewController.h"

@interface GuideIntegralViewController ()

/**
 积分
 */
@property (nonatomic,strong) RsScoreDetails *integralDatas;

@end

@implementation GuideIntegralViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self getIntegralDataAction];
    [self addChildViewController];
}

#pragma mark - 获取积分数据
- (void)getIntegralDataAction
{
    WS(weakSelf);
    NSString *url = [NSString stringWithFormat:SERVERREQUESTURL(INTEGRALQUERY),[Shoppersmanager manager].Shoppers.employee.fid];
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:url WithCallClass:weakSelf WithRequestType:ONE WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            weakSelf.integralDatas = [[RsScoreDetails alloc]initWithDictionary:returnValue[@"data"] error:nil];
            [weakSelf integralAssignment:weakSelf.integralDatas];
        }else {
            [weakSelf ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        
    } WithFailureBlock:^(NSError *error) {
        
    }];
}

#pragma mark - 积分赋值
- (void)integralAssignment:(RsScoreDetails *)scoreModel
{
    self.currentIntegralLabel.text = [NSString stringWithFormat:@"%.0lf",scoreModel.currentScore];
    self.quarterIntegralLabel.text = [NSString stringWithFormat:@"%ld",scoreModel.quarterlyRanking];
    self.yearIntegralLabel.text = [NSString stringWithFormat:@"%ld",scoreModel.annualRanking];
}


#pragma mark - 添加积分明细、导购头像
- (void)addChildViewController
{
    PaymentsViewController *payments = [[[self class] getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"PaymentsViewController"];
    [self addChildViewController:payments];
    payments.view.frame = CGRectMake(0, 50, self.integralDetailsView.mj_w, self.integralDetailsView.mj_h-50);
    [self.integralDetailsView addSubview:payments.view];
    NSString *headerurl = [Shoppersmanager manager].Shoppers.employee.picture;
    [self.guideHeaderView sd_setImageWithURL:[NSURL URLWithString:headerurl] placeholderImage:ReplaceImage];
}


#pragma mark - 礼品兑换
- (IBAction)exchangeButtonClick:(UIButton *)sender {
}









- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}


@end
