//
//  FootSubView.m
//  Lighting
//
//  Created by mac on 16/5/10.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "FootSubView.h"

@implementation FootSubView
- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
    
        [self initdata];
        [self initSubView];
    }
    return self;
}

-(void)initdata
{
//    NSString *imageName = [NSString stringWithFormat:@"backView" ];
//    UIImage *image=[UIImage imageNamed:imageName];
    self.dataArray=[[NSMutableArray alloc]init];
    //    待接收
}
-(void)initSubView
{
    self.selectBtn=[UIButton buttonWithType:UIButtonTypeCustom];
    self.selectBtn.frame=CGRectMake(30, 50, 60, 60);
    [self.selectBtn setBackgroundImage:[UIImage imageNamed:@"场景2"] forState:UIControlStateNormal];
    self.selectBtn.tag=200;
    [self.selectBtn addTarget:self action:@selector(footBtnDidSelected:) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:self.selectBtn];
    self.scrollView=[[UIScrollView alloc]initWithFrame:CGRectMake(100, 0, self.frame.size.width-100, self.frame.size.height)];
    // 禁用滚动条，只设置水平方向的滚动条即可，竖直方向的滚动范围是0，所以没必要设置
    self.scrollView.showsHorizontalScrollIndicator = NO;
     [self addSubview:self.scrollView];
    // contentSize的y值为0表示在垂直方向上不做滚动
    [self showSecenePicture];
    
}
-(void)showSecenePicture
{
     [self.scrollView.subviews makeObjectsPerformSelector:@selector(removeFromSuperview)];
    self.scrollView.contentSize = CGSizeMake((self.dataArray.count+1) * (100+10), 0);
    for (int i=0; i<self.dataArray.count; i++) {
        UIButton *button=[[UIButton alloc]initWithFrame:CGRectMake(i*(125+10), 30, 125, 100)];
        UIImage *image=[self.dataArray objectAtIndex:i];
        [button setImage:image forState:UIControlStateNormal];
        button.tag=100+i;
        [button addTarget:self action:@selector(clicked:) forControlEvents:UIControlEventTouchUpInside];
        UILongPressGestureRecognizer *longPressGR =
        [[UILongPressGestureRecognizer alloc] initWithTarget:self action:@selector(longPress:)];
        longPressGR.minimumPressDuration = 0.5;
        [button addGestureRecognizer:longPressGR];
        
        [self.scrollView addSubview:button];
    }

}
//单次点击 设置为背景色
-(void)clicked:(UIButton*)sender
{
    NSLog(@"%ld",(long)(sender.tag));
    if ([self.delegate respondsToSelector:@selector(resetSuperBackGroundImage:)]) {
        
        [self.delegate resetSuperBackGroundImage:sender.imageView.image];
    }

//    resetSuperBackGroundImage
}
//长按   删除已添加
-(void)longPress:(id)sender
{
    UILongPressGestureRecognizer *longPress=sender;
    if (longPress.state == UIGestureRecognizerStateBegan) {
        NSInteger index=longPress.view.tag-100;
        if (self.dataArray.count>index) {
            [self.dataArray removeObjectAtIndex:index];
            [self showSecenePicture];
        }

    }
    else {
        
    }
    
    

    NSLog(@"长按");
}
//回调
-(void)footBtnDidSelected:(UIButton *)sender
{
    if ([self.delegate respondsToSelector:@selector(buttonClick:withButton:)]) {
        
        [self.delegate buttonClick:sender.tag withButton:sender];
    }

}
-(void)addFootSubViewImage:(UIImage*)image
{
    [self.dataArray addObject:image];
    [self showSecenePicture];  //重新绘制图片数量
}
/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
